

#ifndef _TS_H
#define _TS_H
#include "mbed.h"

extern int         TS_Init   (void);
extern int         TS_Write  (unsigned char reg, unsigned int val);
extern unsigned int TS_Read   (unsigned char reg, int num);
extern int ts_XY( int *x,int *y,int *z);

#define	TS_CHIP_ID			0x00
#define	TS_ID_VER			0x02
#define	TS_SYS_CTRL1		0x03
#define	TS_SYS_CTRL2		0x04
#define	TS_SPI_CFG			0x08
#define	TS_INT_CTRL			0x09
#define	TS_INT_EN			0x0A
#define	TS_INT_STA			0x0B
#define	TS_GPIO_EN			0x0C
#define	TS_GPIO_INT_STA		0x0D
#define	TS_ADC_INT_EN		0x0E
#define	TS_ADC_INT_STA		0x0F
#define	TS_GPIO_SET_PIN		0x10
#define	TS_GPIO_CLR_PIN		0x11
#define	TS_GPIO_MP_STA		0x12
#define	TS_GPIO_DIR			0x13
#define	TS_GPIO_ED			0x14
#define	TS_GPIO_RE			0x15
#define	TS_GPIO_FE			0x16
#define	TS_GPIO_AF			0x17
#define	TS_ADC_CTRL1		0x20
#define	TS_ADC_CTRL2		0x21
#define	TS_ADC_CAPT			0x22
#define	TS_ADC_DATA_CH0		0x30
#define	TS_ADC_DATA_CH1		0x32
#define	TS_ADC_DATA_CH2		0x34
#define	TS_ADC_DATA_CH3		0x36
#define	TS_ADC_DATA_CH4		0x38
#define	TS_ADC_DATA_CH5		0x3A
#define	TS_ADC_DATA_CH6		0x3C
#define	TS_ADC_DATA_CH7		0x3E
#define	TS_TSC_CTRL			0x40
#define	TS_TSC_CFG			0x41
#define	TS_WDW_TR_X			0x42
#define	TS_WDW_TR_Y			0x44
#define	TS_WDW_BL_X			0x46
#define	TS_WDW_BL_Y			0x48
#define	TS_FIFO_TH			0x4A
#define	TS_FIFO_STA			0x4B
#define	TS_FIFO_SIZE		0x4C
#define	TS_TSC_DATA_X		0x4D
#define	TS_TSC_DATA_Y		0x4F
#define	TS_TSC_DATA_Z		0x51
#define	TS_TSC_DATA_XYZ		0x52
#define	TS_TSC_FRACTION_Z	0x56
#define	TS_TSC_DATA_AI		0x57
#define	TS_TSC_DATA_NAI		0xD7
#define	TS_TSC_I_DRIVE		0x58
#define	TS_TSC_SHIELD		0x59
#define	TS_TEMP_CTRL		0x60
#define	TS_TEMP_DATA		0x61
#define	TS_TEMP_TH			0x62

#define SYS_CTRL2_ADC_OFF   0x01	  //Switch off the clock supply to the ADC
#define SYS_CTRL2_TSC_OFF   0x02	  //Switch off the clock supplyto the touchscreen controller
#define SYS_CTRL2_GPIO_OFF   0x04	 //Switch off the clock supply to the GPIO
#define SYS_CTRL2_TS_OFF   0x08		 //Switch off the clock supply to the temperature sensor

#define SYS_CTRL1_SOFT_RESET 0x02	//Reset the STMPE811 using the serial communication interface
#define SYS_CTRL1_HIBERNATE 0x01	//Force the device into hibernation mode

#define INT_TOUCH_DET 	0x01	//Touch is detected
#define INT_FIFO_TH		0x02	// FIFO is equal or above threshold value.
#define INT_FIFO_OFLOW	0x04	// FIFO is overflowed
#define INT_FIFO_FULL	0x08	// FIFO is full
#define INT_FIFO_EMPTY	0x10	// FIFO is empty
#define INT_TEMP_SENS	0x20	//Temperature threshold triggering
#define INT_ADC			0x40	// Any enabled ADC interrupts
#define INT_GPIO			0x80	//Any enabled GPIO interrupts



#define TS_10us 	0x00 
#define TS_100us	0x01 
#define TS_50us		0x02 
#define TS_1ms		0x03 
#define TS_5ms		0x04 
#define TS_10ms		0x05
#define TS_50ms		0x06  
#define TS_100ms	0x07 
#endif /* _TS_H */

