/* DS2450 specific values (see datasheet http://www.maximintegrated.com/datasheet/index.mvp/id/7953) */
#ifndef __MAX31850_H__
#define __MAX31850_H__
#define MAX31850_ID 0x3B
#define MAX31850_SP_SIZE 9

#define MAX31850_CONVERT_T    0x44   //  0x44
#define MAX31850_READ_POWER_SUPPLY    0xB4
#define MAX31850_READ           0xBE

#define MAX31850_ADC_TEMP_TC_UNIT   0.25
#define MAX31850_ADC_TEMP_CJ_UNIT   0.0625
#define MAX31850_K               41.276//41.276µV/C

#define MAX31850_ERR_FAULT -10;
#define MAX31850_ERR_SHORT2VDD -12;
#define MAX31850_ERR_SHORT2GND -13;
#define MAX31850_ERR_OPEN_CIRCUIT -14;
/**
 *    @brief  lecture  registre MAX31850
 *    @param  [in] uint8_t id[] tableau d'identifiant OW
 *    @param  [out] uint8_t  sp[] tableau de registre
 *    @param  [in] uint8_t n bus ow
 *    @return OW_OK si erreur retourne OW_ERROR_CRC
 *    @date 02/12/2013
 *
 */
int MAX31850_Read_Scratch(uint8_t id[],uint8_t sp[],uint8_t n) ;

/**
 *    @brief  lecture  temperature thermocouple Linearized MAX31850
 *    @param  [in] uint8_t sp[] tableau registre MAX31850
 *    @param  [out] float temperature thermocouple Linearized degre Celsuis
 *    @return OW_OK si erreur retourne ERROR
 *    @date 04/12/2013
 *
 */
 int MAX31850_Temp_TRUE(uint8_t *sp,double *temp);
 
/**
 *    @brief  lecture  temperature thermocouple MAX31850
 *    @param  [in] uint8_t sp[] tableau registre MAX31850
 *    @param  [out] float temperature thermocouple degre Celsuis
 *    @return OW_OK si erreur retourne ERROR
 *    @date 04/12/2013
 *
 */
 int MAX31850_Temp_TC(uint8_t *sp,float *temp) ;
 
/**
 *    @brief  lecture  temperature cold junction MAX31850
 *    @param  [in] uint8_t sp[] tableau registre MAX31850
 *    @param  [out] float temperature cold junction degre Celsuis
 *    @return OW_OK si erreur retourne ERROR
 *    @date 04/12/2013
 *
 */
int MAX31850_Temp_CJ(uint8_t *sp,float *temp) ;

/**
 *    @brief  start convertion MAX31850
 *    @param  [in] uint8_t id[] tableau d'identifiant OW
 *    @param  [in] uint8_t n bus ow
 *    @return OW_OK 
 *    @date 02/12/2013
 *
 */
int MAX31850_Start_meas(uint8_t id[],uint8_t n);
#endif 