/**
 *  @brief MAX31850
 *  @date 02/06/2014
 *  @author F.BLANC LAAS-CNRS
 *
 */
#include "mbed.h"
#include <stdint.h>
#include <string.h>
#include <map>

#include "onewire.h"
#include "shtlib.h"

#define VERSION "TK_2014_06_02"
//OW
uint8_t gSensorIDs[MAXBUS][MAXSENSORS][OW_ROMCODE_SIZE];
uint8_t nSensors[MAXBUS];
//file
LocalFileSystem local("local");

//console
Serial pc(USBTX, USBRX); // tx, rx
char txt[128];
//LED
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
// SHT
SHT75 sht(p19, p20);
int shtpresent=false;
char sht_temp_code[32],sht_humi_code[32];
int owpresent=false;
//MAX31850
class Max31850
{
private :
    char owID[17];
    uint64_t uint64_owID;
    char tkID[5];
    float offset;

public :
    Max31850();
    char *Get_owID();
    uint64_t Get_uint64_owID();
    char *Get_tkID();
    float Get_offset();

    void Set_owID(char *idow);
    void Set_tkID(char *tk);
    void Set_offset(float off);

    ~Max31850();
};
Max31850::Max31850()
{

}
char * Max31850::Get_owID()
{
    return owID;
}
uint64_t Max31850::Get_uint64_owID()
{
    return uint64_owID;
}
char * Max31850::Get_tkID()
{
    return tkID;
}
float Max31850::Get_offset()
{
    return offset;
}
void Max31850::Set_owID(char *idow)
{
    for(int i=0; i<17; ++i)
        owID[i]=idow[i];
    uint64_owID=uint64_id( (uint8_t *)owID);
}
void Max31850::Set_tkID(char *tk)
{
    for(int i=0; i<5; ++i)
        tkID[i]=tk[i];
}
void Max31850::Set_offset(float off)
{
    offset=off;
}

Max31850::~Max31850()
{
    delete [] owID;
    delete [] tkID;

}

map < uint64_t, Max31850 *> mMax31850;

//pc_rx


void pc_rx(void)
{
    char c;

    c=pc.getc();
    if (owpresent) {
        int n;
        int num_sensor;
        uint64_t uint64_owID;
        uint8_t sp[MAX31850_SP_SIZE];
        float temp;
        int err;
        switch (c) {
            case '1':
                n=0;
                num_sensor=0;
                uint64_owID = uint64_id(&gSensorIDs[n][num_sensor][0]);
                for (uint8_t i=0 ; i< MAX31850_SP_SIZE; i++ )
                    sp[i]=0;
                MAX31850_Read_Scratch(gSensorIDs[n][num_sensor],sp,n) ;
                err = MAX31850_Temp_TC(sp,&temp);
                if(err) {
                    pc.printf( "-1.0\r ");
                } else {
                    float temp_CJ;
                    double temp_true;
                    MAX31850_Temp_CJ(sp,&temp_CJ);
                    MAX31850_Temp_TRUE(sp,&temp_true);
                    temp_true=temp_true-mMax31850[uint64_owID]->Get_offset();
                    pc.printf( "%f\r",temp_true);

                }
                MAX31850_Start_meas(gSensorIDs[n][num_sensor],n);
                break;
            case '2':
                n=0;
                num_sensor=1;
                uint64_owID = uint64_id(&gSensorIDs[n][num_sensor][0]);
                for (uint8_t i=0 ; i< MAX31850_SP_SIZE; i++ )
                    sp[i]=0;
                MAX31850_Read_Scratch(gSensorIDs[n][num_sensor],sp,n) ;
                err = MAX31850_Temp_TC(sp,&temp);
                if(err) {
                    pc.printf( "-1.0\r ");
                } else {
                    float temp_CJ;
                    double temp_true;
                    MAX31850_Temp_CJ(sp,&temp_CJ);
                    MAX31850_Temp_TRUE(sp,&temp_true);
                    temp_true=temp_true-mMax31850[uint64_owID]->Get_offset();
                    pc.printf( "%f\r",temp_true);

                }
                MAX31850_Start_meas(gSensorIDs[n][num_sensor],n);
                break;
            case '3':
                n=0;
                num_sensor=2;
                uint64_owID = uint64_id(&gSensorIDs[n][num_sensor][0]);
                for (uint8_t i=0 ; i< MAX31850_SP_SIZE; i++ )
                    sp[i]=0;
                MAX31850_Read_Scratch(gSensorIDs[n][num_sensor],sp,n) ;
                err = MAX31850_Temp_TC(sp,&temp);
                if(err) {
                    pc.printf( "-1.0\r ");
                } else {
                    float temp_CJ;
                    double temp_true;
                    MAX31850_Temp_CJ(sp,&temp_CJ);
                    MAX31850_Temp_TRUE(sp,&temp_true);
                    temp_true=temp_true-mMax31850[uint64_owID]->Get_offset();
                    pc.printf( "%f\r",temp_true);

                }
                MAX31850_Start_meas(gSensorIDs[n][num_sensor],n);
                break;
        }
    }

    if(c=='*') {
        pc.printf("Mbed Temp tk\r");
    }

}






#define DELAISMESURE 1
int delaismesure=DELAISMESURE;
int main(void)
{
    uint8_t num_sensor;
    //init SHT
    shtpresent=sht_init(sht, "0002F7F070DB", sht_temp_code, sht_humi_code);

    //init FILEMAX31850
    int nbMAX31850;
    FILE *fpini = fopen("/local/tk.ini", "r");
    if(fpini == NULL) {
        ;
    } else {
        fscanf(fpini,"%d",&nbMAX31850);
        for (int i=0; i<nbMAX31850; ++i) {
            uint64_t uint64_owID;
            char owID[17];
            char owIDinv[17];
            fscanf(fpini,"%s ",owID);

            owIDinv[0]=owID[14];
            owIDinv[1]=owID[15];
            for(int j=2; j<14; ++j) {
                owIDinv[j]=owID[j];
            }
            owIDinv[14]=owID[0];
            owIDinv[15]=owID[1];
            owIDinv[16]=owID[16];
            uint64_owID = strtoull(owIDinv,NULL,16);
            mMax31850[uint64_owID] = new Max31850;
            mMax31850[uint64_owID]->Set_owID(owID);
            char tkID[5];
            fscanf(fpini,"%s",tkID);
            mMax31850[uint64_owID]->Set_tkID(tkID);
            float offset;
            fscanf(fpini,"%f",&offset);
            mMax31850[uint64_owID]->Set_offset(offset);

        }
        fclose(fpini);
    }
    //***init OW

    for (uint8_t n=0; n<MAXBUS; ++n) {
        search_sensors(n,&nSensors[n],gSensorIDs);
        owpresent+=nSensors[n];
        if (owpresent) {
            for (num_sensor=0; num_sensor<nSensors[n]; ++num_sensor) {

                switch (gSensorIDs[n][num_sensor][0]) {

                        //MAX31850
                    case MAX31850_ID:


                        MAX31850_Start_meas(gSensorIDs[n][num_sensor],n);
                        wait(0.1);

                        break;
                }
            }
        }
    }


    while (1) {
        if (pc.readable())
            pc_rx();
    }
    return 0;
}