#include "shtlib.h"

int sht_writefile(SHT75 sht,float *ptr_temperature,float *ptr_humidity) {
    float humi_f,rh_lin,rh_true;           // working registers for Illustration purposes
    int t;                                // temporary store for the temp ticks
    int h;                                // temp store for the humidity ticks
    sht.readTempTicks(&t);
    *ptr_temperature = ((float)(t) * SHT_D2) + SHT_D1;
    sht.readHumidityTicks(&h);
    humi_f = (float)(h);
    rh_lin = SHT_C3 * humi_f * humi_f + SHT_C2 * humi_f + SHT_C1;
    rh_true=(((*ptr_temperature/100)-25)*(SHT_T1+SHT_T2*humi_f)+rh_lin);
    if (rh_true>100)rh_true=-1;                            //cut if the value is outside
    if (rh_true<1)rh_true=-1;                                //the physical possible range
    *ptr_humidity = rh_true;
    return 0;
}


int sht_init(SHT75 sht, const char *hwAddr, char *text_temp, char *text_humi) {
    int t;
    char shtcode[9];
    sht.reset();
    if (sht.readTempTicks(&t)==true) {
        shtcode[7]=hwAddr[5];
        shtcode[6]=hwAddr[4];
        shtcode[5]=hwAddr[3];
        shtcode[4]=hwAddr[2];
        shtcode[3]=hwAddr[1];
        shtcode[2]=hwAddr[0];
        shtcode[1]=0x00;
        shtcode[0]=0x80;    //famille SHT_temp
        shtcode[8]=crc8((uint8_t*)&shtcode[0],8);
        sprintf(text_temp,"%02X%02X%02X%02X%02X%02X%02X%02X%02X",
                shtcode[0], shtcode[1], shtcode[2],
                shtcode[3], shtcode[4], shtcode[5],
                shtcode[6], shtcode[7], shtcode[8]);
        shtcode[0]=0x81;    //famille SHT_humi
        shtcode[8]=crc8((uint8_t*)&shtcode[0],8);
        sprintf(text_humi,"%02X%02X%02X%02X%02X%02X%02X%02X%02X",
                shtcode[0], shtcode[1], shtcode[2],
                shtcode[3], shtcode[4], shtcode[5],
                shtcode[6], shtcode[7], shtcode[8]);
        return true; //sht present
    }
    return false;//sht absent
}