#include "mbed.h"
#include "USBSerial.h"
#define VERSION "27_06_2014"
#define SPEED 5000//1000 //µs
#define BLOCUSB 64 //64
#define NBCHAN 2
#define NBSAMPLE BLOCUSB/NBCHAN //  2 samples 16bit
#define __KL25
#if defined( __LPC1768_SDA)
#define CIBLE "LPC1768_SDA"
char str[256];
uint8_t start_str=0;
Serial pc(USBTX, USBRX);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogIn adc_1(p16);
AnalogIn adc_2(p17);
#endif
#if defined( __LPC1768)
#define CIBLE "LPC1768"
USBSerial pc;
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogIn adc_1(p16);
AnalogIn adc_2(p17);
#endif
#if defined( __KL25)
#define CIBLE "KL25"
USBSerial pc;
DigitalOut  led2(LED_GREEN);
DigitalOut  led3(LED_RED);
DigitalOut led4(LED_BLUE);
AnalogIn adc_1(PTB0);
AnalogIn adc_2(PTB1);
#endif
#if defined( __K64F)
#define CIBLE "K64F"
USBSerial pc;
DigitalOut led2(LED2);
DigitalOut led3(LED1);
DigitalOut led4(LED3);
AnalogIn adc_1(PTB2);
AnalogIn adc_2(PTB3);
#endif
uint16_t  T_hma_u16[2][BLOCUSB];
uint16_t index_hma_write=0;

uint16_t index_hma_read=0;
bool t_write=0;
bool highspeed=0;
int speed; // int for scanf(%d)
bool start_mesure;
bool flag_write_USB=0;
Ticker flipperADC;

void flipADC()
{
led2=1;
    T_hma_u16[t_write][index_hma_write++]=adc_1.read_u16(); //read ADC
    T_hma_u16[t_write][index_hma_write++]=adc_2.read_u16(); //read ADC


    if(index_hma_write>=NBSAMPLE) {
        flag_write_USB=1;
        t_write=!t_write; //toggel buffer
        index_hma_read=index_hma_write;
        index_hma_write=0;
    }
led2=0;
}

Ticker flipperUSB;
void flipUSB()
{

    flag_write_USB=1;

}

void pc_rx(void)
{

#if defined( __LPC1768_SDA)
    for(; pc.readable()==true; ++start_str) {
        str[start_str]=pc.getc();
    }

    if( strncmp(str,"ABORt",strlen("ABORt"))==0 ) {//ABORT
        start_mesure=0;
        flipperADC.detach();
        t_write=0;
        index_hma_read=0;
        index_hma_write=0;
        for(int i=0; i<256; ++i) {
            str[i]='\0';

        }

    }
    if(start_mesure==0) {
        if( strncmp(str,"*IDN?",strlen("*IDN?"))==0 ) {//*IDN?
            pc.printf("LAAS-CNRS ,HMA ,%s ,%s\r",CIBLE,VERSION);
            for(int i=0; i<256; ++i) {
                str[i]='\0';

            }
        } else if( strncmp(str,"MEASure",strlen("MEASure"))==0 ) {//MEASure
            start_mesure=1;
            flipperADC.attach_us(&flipADC, speed);
            for(int i=0; i<256; ++i) {
                str[i]='\0';

            }
        } else if( strncmp(str,"TIME",strlen("TIME"))==0 ) {//TIME
            sscanf(&str[strlen("TIME")],"%d",&speed);
            if(speed<1)
                speed=1;
            for(int i=0; i<256; ++i) {
                str[i]='\0';

            }
        }else if( strncmp(str,"HS",strlen("HS"))==0 ) {//HS
            highspeed=1;
            for(int i=0; i<256; ++i) {
                str[i]='\0';

            }
        }else if( strncmp(str,"LS",strlen("LS"))==0 ) {//Ls
            highspeed=0;
            for(int i=0; i<256; ++i) {
                str[i]='\0';

            }
        }
    } 
    for(int i=0; i<start_str; ++i) {
        if(str[i]=='\r') {
            for(int j=0; j<256; ++j) {
                str[j]='\0';

            }
            start_str=0;

        }

    }

#else
    char str[32];
    for(int start_str=0; pc.readable()!=0; ++start_str) {
        str[start_str]=pc.getc();
    }
    if( strncmp(str,"ABORt",strlen("ABORt"))==0 ) {
        start_mesure=0;
        flipperADC.detach();
        t_write=0;
        index_hma_read=0;
        index_hma_write=0;

    }
    if(start_mesure==0) {
        if( strncmp(str,"*IDN?",strlen("*IDN?"))==0 ) {
            pc.printf("LAAS-CNRS ,HMA ,%s ,%s\r",CIBLE,VERSION);
        } else if( strncmp(str,"MEASure",strlen("MEASure"))==0 ) {
            start_mesure=1;
            flipperADC.attach_us(&flipADC, speed);
        } else if( strncmp(str,"TIME",strlen("TIME"))==0 ) {
            sscanf(&str[strlen("TIME")],"%d",&speed);
            if(speed<1)
                speed=1;
        }else if( strncmp(str,"HS",strlen("HS"))==0 ) {
            highspeed=1;
        }else if( strncmp(str,"LS",strlen("LS"))==0 ) {
            highspeed=0;
        }
    }

#endif
}

int main()
{
#if defined( __LPC1768_SDA)
    pc.baud(460800);
    for(int i=0; i<256; ++i) {
        str[i]='\0';
    }
#endif
    speed=SPEED;
    start_mesure=0;
    while(1) {

        if (pc.readable()) {
            pc_rx();
        }

        if(flag_write_USB==1) {
            led2=1;
                led3=1;
    led4=1;
            flag_write_USB=0;
            if(highspeed==0)
            {
                pc.printf("%04d%c\r",index_hma_read,'\0'); //'\0'fin de chaine ASCII '\r' fin de transmission
            }
            for(unsigned int i=0; i<index_hma_read*NBCHAN; i+=BLOCUSB ) { // 2 cannaux de 16bits
#if defined( __LPC1768_SDA)
                char* ptr=(char*)&T_hma_u16[!t_write][0];

                for(uint16_t i=0; i<index_hma_read; ++i) {
                    pc.putc(*ptr++);
                    pc.putc(*ptr++);
                }
#else
                pc.writeBlock((uint8_t*)&T_hma_u16[!t_write][i/NBCHAN],BLOCUSB );//For more efficiency, a block of size 64 (maximum size of a bulk endpoint) has to be written.
#endif
            }
led2=0;
        }
    }
}
