#include "mbed.h"
#include "freetronicsLCDShield.h"
#include "DHT.h"

freetronicsLCDShield lcd(D8, D9, D4, D5, D6, D7, D3, A0);
DHT sensor(A5, DHT11);
DigitalOut myled(LED1);
Ticker flipper;
bool up=true;
void readBP()
{
    float bp=lcd.readButton();
    if (bp<0.25)
        up=true;
    else if (bp<0.5)
        up=false;
}
int main()
{
    flipper.attach(&readBP, 0.1);
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    // turn on the back light (it's off by default)
    lcd.setBackLight(true);
    lcd.cls();
    // print the first line and wait 3 sec
    lcd.printf("mbed DHT11");
    wait(3);

    // print the counter prefix; the number will be printed in the while loop




    while (1) {

        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            if(up==true) {
                lcd.setCursorPosition(0, 0);
                lcd.printf("Temperature %4.2f   ",c);
                lcd.setCursorPosition(1, 0);
                lcd.printf("Humidity %4.2f   ", h);
            }
            if(up==false) {

                lcd.setCursorPosition(0, 0);
                lcd.printf("Humidity %4.2f   ", h);
                lcd.setCursorPosition(1, 0);
                lcd.printf("Dew point %4.2f  ",dp);
            }
        } else {

            lcd.setCursorPosition(0, 0);
            lcd.printf("mbed DHT11     ");
            lcd.setCursorPosition(1, 0);
            lcd.printf("Error: %d      ", error);
        }


        wait(0.5f);
    }
}
