/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "AnalogIn_Diff.h"

#if FSL_FEATURE_ADC_HAS_DIFF_MODE



AnalogIn_Diff::AnalogIn_Diff(int adc_ch)
{
    
    const uint32_t temp[] = ADC_BASE_ADDRS;
    for (int i = 0; i < sizeof(temp) / sizeof(temp[0]); i++)
        adc_addrs[i] = temp[i];

    
    instance=(adc_ch>>1)&1;
    chnNum=(adc_ch>>0)&1;
          
    
    CLOCK_SYS_EnableAdcClock(instance);

    uint32_t bus_clock;
    CLOCK_SYS_GetFreq(kBusClock, &bus_clock);
    uint32_t clkdiv;
    for (clkdiv = 0; clkdiv < 4; clkdiv++) {
        if ((bus_clock >> clkdiv) <= MAX_FADC)
            break;
    }
    if (clkdiv == 4) {
        clkdiv = 0x3; //Set max div
    }

    /* adc is enabled/triggered when reading. */

    ADC_HAL_Init(adc_addrs[instance]);
    ADC_HAL_SetClkSrcMode(adc_addrs[instance], kAdcClkSrcOfBusClk);
    ADC_HAL_SetClkDividerMode(adc_addrs[instance], (adc_clk_divider_mode_t)(clkdiv & 0x3));
    ADC_HAL_SetRefVoltSrcMode(adc_addrs[instance], kAdcRefVoltSrcOfVref);
    ADC_HAL_SetResolutionMode(adc_addrs[instance], kAdcResolutionBitOfDiffModeAs16);
    ADC_HAL_SetContinuousConvCmd(adc_addrs[instance], false);//false
    ADC_HAL_SetHwTriggerCmd(adc_addrs[instance], false); /* sw trigger */
    ADC_HAL_SetHwAverageCmd(adc_addrs[instance], false); /*Average*/
    //ADC_HAL_SetHwAverageCmd(adc_addrs[instance], true);
    //ADC_HAL_SetHwAverageMode(adc_addrs[instance], kAdcHwAverageCountOf32);
    ADC_HAL_SetChnMuxMode(adc_addrs[instance], kAdcChnMuxOfB); /* only B channels are avail */
    
    INT_SYS_DisableIRQ(ADC0_IRQn);
    INT_SYS_DisableIRQ(ADC1_IRQn);

}

AnalogIn_Diff::~AnalogIn_Diff() { }

void AnalogIn_Diff::test (int x)
{
       printf("\r\n %i: 0x%08lx\r\n",x,(long)adc_addrs[instance]);
}


#if 1
int16_t AnalogIn_Diff::read_raws16()    // Returns a 16bit signed integer
{
    /* sw trigger (SC1A) */
    ADC_HAL_ConfigChn(adc_addrs[instance], 0, false, true, chnNum); //baseAddr, chnGroup,  intEnable, diffEnable,  chnNum
    while (!ADC_HAL_GetChnConvCompletedCmd(adc_addrs[instance], 0));
   return ADC_HAL_GetChnConvValueRAW(adc_addrs[instance], 0);

}
#else

int16_t AnalogIn_Diff::read_raws16()    // Returns a 16bit signed integer
{
    /* sw trigger (SC1A) */

    static int started = 0;

    if (!started)
    {
        started = 1;
        ADC_HAL_ConfigChn(adc_addrs[instance], 0, false, true, chnNum);
    }
    if (started && ADC_HAL_GetChnConvCompletedCmd(adc_addrs[instance], 0))
    {
        started = 0;
        return ADC_HAL_GetChnConvValueRAW(adc_addrs[instance], 0);
    }
    return -32768;
}

#endif

float AnalogIn_Diff::read()
{
    int16_t value = read_raws16();
    return (float)value * (1.0f / (float)0xFFFF);
}

#endif // FSL_FEATURE_ADC_HAS_DIFF_MODE
