#include "mbed.h"
#include "AnalogIn_Diff.h"


AnalogIn_Diff::AnalogIn_Diff(int a2d_number) : ch(a2d_number) {
    if(ch) BW_SIM_SCGC3_ADC1(1); // Turn on clock as needed
    else BW_SIM_SCGC6_ADC0(1);
    BW_ADC_SC1n_DIFF(ch, 0, 1);     //  Differential Mode
    BW_ADC_CFG1_ADICLK(ch, 0);      //  Bus Clock
    BW_ADC_CFG1_MODE(ch, 3);        //  16Bit differential mode
    BW_ADC_CFG1_ADLSMP(ch, 0);      //  Short Sample Window 
    BW_ADC_CFG1_ADIV(ch, 3);        //  Clock / 8
    BW_ADC_CFG1_ADLPC(ch, 0);       //  Normal Power Mode
}

AnalogIn_Diff::~AnalogIn_Diff() { }

int16_t AnalogIn_Diff::read_16(int channel) {  // Returns a 16bit signed integer
    BW_ADC_SC1n_ADCH(ch, 0, channel);      //  Trigger Conversion
    while(!BR_ADC_SC1n_COCO(ch, 0));    //  Wait for conversion to finish
    return(BR_ADC_Rn_D(ch, 0));         //  Return the result
}

float AnalogIn_Diff::read(int channel) {
    int16_t i;
    float t;
    BW_ADC_SC1n_ADCH(ch, 0, channel);
    while(!BR_ADC_SC1n_COCO(ch, 0));
    i =  BR_ADC_Rn_D(ch, 0);
    t = ((float) i);
    t = t / 32768.0f;
    return(t);
}
