/* 
 * Copyright (c) 2014 LAAS-CNRS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "AnalogIn_Diff.h"

#define VERSION "AnalogIn_Diff_helloworld_2016_01_08"
#define CIBLE "K64F"
Serial pc(USBTX, USBRX);
AnalogIn_Diff adc_diff(ADC_DIFF(0,1));
Ticker flipperADC;
bool flag_TX=false;
void flipADC()
{
    flag_TX=true;
}
int main()
{
       pc.baud(115200);
    pc.printf("%s %s\r\n",VERSION,CIBLE);
    flipperADC.attach(&flipADC, 1.0);
    
    while (true) {
        if(flag_TX) {
            pc.printf("V= %f raw=%d\r\n",adc_diff.read()*6.6,adc_diff.read_raws16());
            flag_TX=false;
        }
    }
}