#include "mbed.h"
#include "math.h"
#include "MovingAverage.h"
#define VERSION "15_07_2014"
#define CIBLE "K64F"
//USBSerial pc;
#define max(a,b) (a>=b?a:b)
#define min(a,b) (a<=b?a:b)
#define UAC_NON 230.0
#define UAC_MAX UAC_NON*1.1
#define UAC_MIN UAC_NON*0.9
#define UAC_NON2 UAC_NON*UAC_NON
#define UAC_MAX2 UAC_MAX*UAC_MAX
#define UAC_MIN2 UAC_MIN*UAC_MIN
struct {
   float   gain;
    float   offset;
//AnalogIn adc;
} adc_volt,adc_curr;
Timer timer_min;
bool F_timer_min=false;
Timer timer_max;
bool F_timer_max=false;
Serial pc(USBTX, USBRX);
AnalogIn adc_1(PTB2);
AnalogIn adc_2(PTB3);
Ticker flipperADC;
DigitalOut led1(LED_RED);
DigitalOut led2(LED_GREEN);
DigitalOut led3(LED_BLUE);
MovingAverage<float> Trms(20,UAC_NON);
MovingAverage<float> moy(20,0);
float min=250000;
float max=0;
bool min_OK=false;
void flipADC()
{
    float val;
    led1=1;
    int val_i32=adc_2.read_u16()-adc_1.read_u16(); //read ADC

    val=(float)val_i32*adc_volt.gain-adc_volt.offset;
moy.Insert(val);
    Trms.Insert(val*val);
    val=Trms.GetAverage();
    max=max(val,max);
    if(min_OK==true)
        min=min(val,min);
    if(val<UAC_MIN2 && F_timer_min ==false)
    {
        timer_min.reset();
        timer_min.start();
        F_timer_min = true;  
    }
    if(val>UAC_MIN2 && F_timer_min ==true)
    {
        timer_min.stop();
        F_timer_min = false;  
    }
    if(val>UAC_MAX2 && F_timer_max ==false)
    {
        timer_max.reset();
        timer_max.start();
        F_timer_max = true;  
    }
    if(val<UAC_MAX2 && F_timer_max ==true)
    {
        timer_max.stop();
        
        F_timer_max = false;  
    }
    led1=0;
}

int main()
{
    led1=1;
    led2=0;
    led3=1;
    pc.baud(115200);
    pc.printf("LAAS-CNRS ,TRMS ,%s ,%s\r",CIBLE,VERSION);
    adc_volt.gain=(1960.0*3.3)/65535.0;
    adc_volt.offset=-17.0;

    flipperADC.attach_us(&flipADC, 1000); //200µs
    wait (5);
min_OK=true;
    while (true) {

        
        led3=1;

        pc.printf("RMS=%f \r\n",sqrt(Trms.GetAverage()));
        pc.printf("min=%0.0f t=%f max=%0.0f t=%f\r\n",sqrt(min),timer_min.read(),sqrt(max),timer_max.read());
        pc.printf("moy=%f \r\n",moy.GetAverage());
        led3=0;
        wait (1);
    }
}