#include "mbed.h"
#include "AnalogIn_Diff.h"
#include "math.h"
#include "MovingAverage.h"

#define VERSION "26_08_2014"
#define CIBLE "K64F"

#define max(a,b) (a>=b?a:b)
#define min(a,b) (a<=b?a:b)

#define R1 1.0E6
#define R2 510.0
#define ADCVREF 3.3
#define GAIN_ACPL_C78 0.125
#define GAIN ((double)((R1+R2)*2.0*GAIN_ACPL_C78*ADCVREF/R2)/65535.0)
#define UAC_NON 230.0
#define UAC_MAX ((int32_t)((double)UAC_NON*1.1/(double)GAIN))
#define UAC_MIN ((int32_t)((double)UAC_NON*0.9/(double)GAIN))
#define UAC_NON2 ((int32_t)((double)UAC_NON/(double)GAIN*(double)UAC_NON/(double)GAIN))
#define UAC_MAX2 ((int32_t)((double)UAC_MAX*(double)UAC_MAX))
#define UAC_MIN2 ((int32_t)((double)UAC_MIN*(double)UAC_MIN))

#define FREQ 50//en HZ
#define TSAMPLE 500 //en µS
#define NSAMPLE ((int32_t)(1/(double)FREQ *1.0E6/(double)TSAMPLE))
#define NADC 0
#define NCHANNEL 1
AnalogIn_Diff a2d(NADC);
struct {
    float   gain;
    float   offset;
//AnalogIn adc;
} adc_volt,adc_curr;
Timer timer_min;
bool F_timer_min=false;
Timer timer_max;
bool F_timer_max=false;
Serial pc(USBTX, USBRX);
//AnalogIn adc_1(PTB2);
//AnalogIn adc_2(PTB3);

Ticker flipperADC;
DigitalOut led1(LED_RED);
DigitalOut led2(LED_GREEN);
DigitalOut led3(LED_BLUE);
MovingAverage<int32_t> Trms(NSAMPLE,0);
MovingAverage<float> moy(NSAMPLE,0.0);
int32_t min=UAC_NON2;
int32_t max=UAC_NON2;
int32_t time_min=0;
int32_t time_max=0;
bool min_OK=false;
void flipADC()
{

    float val;
    int32_t  val_i32;
    led1=1;

    val_i32=a2d.read_16(NCHANNEL);
    val=(float)val_i32*adc_volt.gain-adc_volt.offset;

    moy.Insert(val);
    Trms.Insert(val_i32*val_i32);

    val_i32=Trms.GetAverage();

    //START
    if(val_i32<UAC_MIN2 && F_timer_min ==false) {
        timer_min.reset();
        timer_min.start();
        F_timer_min = true;
        min=UAC_NON2;
    }
    if(val_i32>UAC_MAX2 && F_timer_max ==false) {
        timer_max.reset();
        timer_max.start();
        F_timer_max = true;
        max=UAC_NON2;
    }
    //STOP
    if(val_i32>UAC_MIN2 && F_timer_min ==true) {
        timer_min.stop();
        F_timer_min = false;
    }

    if(val_i32<UAC_MAX2 && F_timer_max ==true) {
        timer_max.stop();
        F_timer_max = false;
    }
    if(timer_min.read_ms()>20 && F_timer_min ==true)  {
        time_min=timer_min.read_ms();
        min=min(val_i32,min);
    }
    if(timer_max.read_ms()>20 && F_timer_max ==true) {
        time_max=timer_max.read_ms();
        max=max(val_i32,max);
    }
    led1=0;
}

int k64f_vref(int v)
{
// v min 0x0 //-16mV

// V mon 0x20 //0mV
// V max 0x3F //+16mV

    BW_VREF_SC_VREFEN(1); //The module is enabled
    BW_VREF_SC_REGEN(1); //Internal 1.75 V regulator is enabled
    BW_VREF_SC_MODE_LV(0); //Bandgap on only, for stabilization and startup
    BW_VREF_TRM_TRIM(v);
    while(BR_VREF_SC_VREFST);// Internal Voltage Reference stable
    BW_VREF_SC_MODE_LV(1); //High power buffer mode enabled
    return 0;
}
int main()
{


    led1=1;
    led2=0;
    led3=1;
    pc.baud(115200);
    pc.printf("LAAS-CNRS ,TRMS ,%s ,%s\r\n",CIBLE,VERSION);
    pc.printf("Tsample:%d ,Nsample:%d\r\n",TSAMPLE,NSAMPLE);
    pc.printf("Umin:%d ,Umax:%d\r\n",UAC_MIN,UAC_MAX);
    pc.printf("Umin2:%d ,Umax2:%d\r\n",min,max);
    pc.printf("gain:%f ,Umon:%0.0f\r\n",GAIN,UAC_NON);
    //k64f_vref(0x20);

    adc_volt.gain=GAIN;
    adc_volt.offset=0.0;

    flipperADC.attach_us(&flipADC, TSAMPLE);
    wait (5);

    while (true) {


        led3=1;

        pc.printf("RMS= %f ",sqrt((float)Trms.GetAverage())*adc_volt.gain);
        pc.printf("min=%0.0f t=%d max=%0.0f t=%d ",sqrt((float)min)*adc_volt.gain,time_min,sqrt((float)max)*adc_volt.gain,time_max);
        pc.printf("moy= %f \r\n",moy.GetAverage());

        led3=0;

        wait (1);
    }
}