#include "mbed.h"
#include "math.h"
#include "MovingAverage.h"
//USBSerial pc;
#define max(a,b) (a>=b?a:b)
#define min(a,b) (a<=b?a:b)
struct {
    double   gain;
    double   offset;
//AnalogIn adc;
} adc_volt,adc_curr;
Serial pc(USBTX, USBRX);
AnalogIn adc_1(PTB2);
AnalogIn adc_2(PTB3);
Ticker flipperADC;
DigitalOut led1(LED_RED);
DigitalOut led2(LED_GREEN);
DigitalOut led3(LED_BLUE);
MovingAverage<float> Trms_float(100,230);
//MovingAverage<int> Trms_int(100,0);
float min=250000;
float max=0;
bool min_OK=false;
void flipADC()
{
    float val;
    led1=1;
    int val_i32=adc_2.read_u16()-adc_1.read_u16(); //read ADC

    val=((float)val_i32*adc_volt.gain)-adc_volt.offset;
    Trms_float.Insert(val*val);
    val=Trms_float.GetAverage();
    max=max(val,max);
    if(min_OK==true)
        min=min(val,min);
    led1=0;
}

int main()
{
    led1=1;
    led2=0;
    led3=1;
    pc.baud(115200);
    adc_volt.gain=129.0*3.3/65535.0;
    adc_volt.offset=0.0;

    flipperADC.attach_us(&flipADC, 200); //200µs
    wait (1);
min_OK=true;
    while (true) {

        
        led3=1;

        pc.printf("RMS=%0.1f \r\n",sqrt(Trms_float.GetAverage()));
        pc.printf("min=%0.1f max=%0.1f\r\n",sqrt(min),sqrt(max));
        led3=0;
        wait (1);
    }
}