#include "mbed.h"
#include "ADC128D818.h"

Serial pc(USBTX, USBRX);
ADC128D818 adc(p9,p10,p26);
AnalogOut dac(p18);
int main()
{
dac=0.5;
    printf("helloword_ADC128D818\r\n");
    wait_ms(100);
    int err=adc.init(ADC_ADDRESS_LOW_LOW, ADC_MODE_0, ADC_VREF_INT, ADC_RATE_CONTINUOUS, ADC_ENABLE_TEMP & ADC_ENABLE_IN1, ADC_INT_TEMP);
    switch (err) {
        case -1:
            printf("No Device\r\n");
            break;
        case -2:
            printf("Busy\r\n");
            break;
    }
    adc.init_limit(ADC_CHANNEL_IN0, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN1, 0xA6, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN2, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN3, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN4, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN5, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_IN6, 0x80, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_TEMP, 30, ADC_LIMIT_HIGH);
    adc.init_limit(ADC_CHANNEL_TEMP, 29, ADC_LIMIT_LOW);
    char reg;
    reg=ADC_REG_Advanced_Configuration_Register;
    printf("reg %02X=%02X\r\n",reg,adc.read_register(reg));
   
    printf("reg %02X=%02X\r\n",0x2C,adc.read_channel(0x0C));
    adc.start();
 
    for(int i=0; i<1000; ++i) {
        wait(1);
        
        printf("ch0:%d : %d\r\n",i,adc.read_channel(ADC_CHANNEL_IN0));
        for( char c=1; c<7 ;++c)
        printf("ch%d:%d : %04X\r\n",c,i,adc.read_channel(c));
       
        printf("temp:%d : %f\r\n",i,(adc.read_channel(ADC_CHANNEL_TEMP)>>7)/2.0);
        reg=0x01;
    printf("reg %02X=%02X\r\n",reg,adc.read_register(reg));
    }

}
