#include "mbed.h"
#include "AD8556.h"
Serial pc(USBTX, USBRX);
AD8556 aop(PTD7); //KL25Z
//AD8556 aop(p21); //MBED
unsigned char mode=ADC_MODE_SIMULATION;
float vdd=5.0,vss=0.0;

void pc_rx(void)
{
    char c;
    c=pc.getc();
    switch (c) {
        case 'h':
        case 'H':
            pc.printf("\r\nHELP\r\n");
            pc.printf("G : GAIN (V/V)\r\n");
            pc.printf("O : OFFSET (V)\r\n");
            pc.printf("M : MODE SIMULATION/FUSE\r\n");
            pc.printf("S : SUPPLY VDD VSS\r\n");
            
            break;
        case 'G':
            float gain;
            pc.printf("\r\nGAIN =");
            pc.scanf("%f",&gain);
            aop.prog_gain(gain,mode);
            pc.printf("%f\r\n",gain);
            break;
        case 'O':
            float offset;
            pc.printf("\r\nOFFSET =");
            pc.scanf("%f",&offset);
            aop.prog_vdac(offset,vdd,vss,mode);
            pc.printf("%f\r\n",offset);
            break;
        case 'M':
            pc.printf("\r\nMODE :");
            pc.printf("\r\n1:SIMULATION");
            pc.printf("\r\n2:FUSE");
            pc.scanf("%d",&mode);
            if(mode==2)
                pc.printf("\r\nFUSE");
                else
                {
                    mode=ADC_MODE_SIMULATION;
                    pc.printf("\r\nSIMULATION");
                }
            break;
        case 'S':
            pc.printf("\r\nSUPPLY :");
            pc.printf("\r\nVCC :");
            pc.scanf("%f",&vdd);
            pc.printf("%f\r\n",vdd);
            pc.printf("\r\nVSS :");
            pc.scanf("%f",&vss);
            pc.printf("%f\r\n",vss);
            break;
    }
}



int main()
{
pc.printf("\r\nAD8556 HelloWolrd 12/09/2013\r\n");
    //aop.init(ADC_Simulate_Parameter_Value,0x00, 0x00,0x7F);

    while (1) {
        if (pc.readable()) //reception d'une trame com
            pc_rx();
    }


}
