/**
 * @brief AD8556:  Digitally Programmable Sensor Signal Amplifier with EMI Filters
 * http://www.analog.com/en/specialty-amplifiers/instrumentation-amplifiers/ad8556/products/product.html
 * @date 05/09/2013
 * @author F.BLANC LAAS-CNRS
 * http://homepages.laas.fr/fblanc/
 */
#ifndef AD8556_H

#define AD8556_H

#include "mbed.h"
enum ADC_MODE {
    ADC_MODE_SENSE_CURENT = 0x00,
    ADC_MODE_SIMULATION = 0x01,
    ADC_MODE_FUSE = 0x02,
    ADC_MODE_READ = 0x03
};
enum ADC_FUNCTION {
    ADC_Change_Sense_Current = 0x00,
    ADC_Simulate_Parameter_Value = 0x01,
    ADC_Program_Parameter_Value = 0x02,
    ADC_Read_Parameter_Value = 0x03
};
enum ADC_PARAMETER {
    ADC_Second_Stage_Gain_Code = 0x00,
    ADC_First_Stage_Gain_Code = 0x01,
    ADC_Output_Offset_Code = 0x02,
    ADC_Other_Functions = 0x03
};
/** AD8556 class.
 *  Used for controlling a AD8556 Instrumentation Amplifiers  connected via Single-wire serial interface.
 *
 */
class AD8556
{
protected:
private:
    /**
     * @brief write_bit
     *
     * @param bit 1 or 0
     */
    void write_bit(unsigned char bit);
    /**
     * @brief read_bit
     *
     * @return bit 1 or 0
     */
    unsigned char read_bit();
    /**
    * @brief trame
    * @param parameter
    * @param mode
    * @param data
    */
    void trame(unsigned char parameter,unsigned char mode,unsigned char data);
public:
    /**
     * @brief Constructor.
     * @param dig
     */
    AD8556(PinName dig);
    DigitalInOut _dig;

    /**
     * @brief Destructor.
     */
    ~AD8556();
    /**
    * @brief init
    * @param First_Stage_Gain_Code
    * @param Second_Stage_Gain_Code
    * @param Vdac_Code
    */
    int init(unsigned char mode=ADC_MODE_SIMULATION, unsigned char First_Stage_Gain_Code=0, unsigned char Second_Stage_Gain_Code=0,unsigned char Vdac_Code=0x7F);
    /**
    * @brief prog_vdac
    * @param vdac consigne (volt)
    * @param vdd positive voltage supply (volt)
    * @param vss nagative voltage supply (volt)
    * @param mode
    */
    void prog_vdac(float vdac, float vdd=5.0 ,float vss=0.0, unsigned char mode=ADC_MODE_SIMULATION);
    /**
    * @brief prog_gain
    * @param gain 70 to 1280

    * @param mode
    */
    void prog_gain(float gain=70.0, unsigned char mode=ADC_MODE_SIMULATION);

};
#endif