/******************************************************
*File Name: Freezer_Guard main.cpp
*Purpose: Freezer Guard System protects your freezer from unintentionaly defrost
*
*Author: denis schnier and fabian bitz @ University of applied sciences bingen
*Changes:
*
* 18.05.2015 initial version
* ...
*******************************************************/

#include "guard.h"
#include "string.h"
#define LIMIT 25   // Temperature Alarm Threshold
byte MAIN_bState;
byte bError;
char cString[25];
char data_array[2];
DigitalOut led4(LED4);  //DEBUG

int main()
{
    int8 i8Value=0; //value has 8 bit + sign
    MAIN_bState=0; //statemachine: 0=no Alarm, 1=Alarm and no Mail sent, 2=Alarm and Mail sent, 3= Pending Alarm Confirmed
    bError=0;
    vGuardInit(); 
    led4=0; //DEBUG
    while(1){
    i8Value=readValue(MCP9808_ADDR);
    wait(1);
    if(i8Value>LIMIT && MAIN_bState==0) MAIN_bState=1;
    if(i8Value<LIMIT) MAIN_bState=0;
    switch(MAIN_bState) {
    case 0: { //normal case
        vLcdIntPrint(i8Value);
         vLcdAlarmPrint("System Running"); 
         vLcdStringPrint("Temperature Ok   \n        ");   
         break;
         }
         
    case 1:{
        vLcdIntPrint(i8Value);
        vLcdAlarmPrint("Alarm!        ");   
        vAudioAlarm();     
//        bError=SendMail(i8Value);
        if(SendMail(i8Value))vLcdStringPrint("Mail Sent!      \n         ");
            else{
                vLcdStringPrint("Mail Not Sent!     \n         ");
                }
        led4=1; //DEBUG

         MAIN_bState=2;
          break;
          }
    case 2:{                        // case: mail sent, alarm pending
         vLcdIntPrint(i8Value);
         vAudioAlarm();
          break;
            }
    case 3:{                            //MAIN_bState=3 could only be set by ISR
         vLcdIntPrint(i8Value);
         break;
            }        
    default:{
          vLcdStringPrint("State Machine Error!");
          break;
          }
        }//state machine
    }//while(1)

}//main
