#include <events/mbed_events.h>
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h" 
#include "ble/DiscoveredService.h" 
#include "ble/services/HeartRateService.h" 

DigitalOut led1(LED1, 1); 
//I2C i2c(p27, p26); // sda, scl
Serial uart(p13, p14);  // tx, rx
static DiscoveredCharacteristic ledCharacteristic; 
static bool triggerLedCharacteristic; 
static const char PEER_NAME[] = "HRM"; 
//const int address = 0x3C<<1;

static EventQueue eventQueue(/* event count */ 16 * EVENTS_EVENT_SIZE); 
char HeartRate_Data = 0;

void periodicCallback(void) { 
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */ 
} 


void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) { 
    // parse the advertising payload, looking for data type COMPLETE_LOCAL_NAME 
    // The advertising payload is a collection of key/value records where 
    // byte 0: length of the record excluding this byte 
    // byte 1: The key, it is the type of the data 
    // byte [2..N] The value. N is equal to byte0 - 1 
    printf("Hello:)\r\n");
    printf(
        "adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n", 
        params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], 
        params->peerAddr[1], params->peerAddr[0], params->rssi, params->isScanResponse, params->type 
    );
    for (uint8_t i = 0; i < params->advertisingDataLen; ++i) { 

        const uint8_t record_length = params->advertisingData[i]; 
        if (record_length == 0) { 
            continue; 
        } 
        const uint8_t type = params->advertisingData[i + 1]; 
        const uint8_t* value = params->advertisingData + i + 2; 
        const uint8_t value_length = record_length - 1; 


        if(type == GapAdvertisingData::COMPLETE_LOCAL_NAME) { 
            if ((value_length == sizeof(PEER_NAME)) && (memcmp(value, PEER_NAME, value_length) == 0)) { 
                printf( 
                    "adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n", 
                    params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], 
                    params->peerAddr[1], params->peerAddr[0], params->rssi, params->isScanResponse, params->type 
                ); 
                BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_RANDOM_STATIC, NULL, NULL); 
                break; 
            } 
        } 
        i += record_length; 
    } 
} 


void serviceDiscoveryCallback(const DiscoveredService *service) { 
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) { 
        printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle()); 
    } else { 
        printf("S UUID-"); 
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID(); 
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) { 
            printf("%02x", longUUIDBytes[i]); 
        } 
        printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    } 
} 


void updateLedCharacteristic(void) { 
    if (!BLE::Instance().gattClient().isServiceDiscoveryActive()) { 
        ledCharacteristic.read(); 
    } 
} 

void triggerToggledWrite(const GattReadCallbackParams *response) { 
    printf("triggerToggledWrite\r\n");
    printf("triggerToggledWrite: handle %u, offset %u, len %u\r\n", response->handle, response->offset, response->len); 
    HeartRate_Data = response->data[1];
    printf("HeartRate_Data = %d\r\n", HeartRate_Data);
    uart.putc(HeartRate_Data);
    ledCharacteristic.read(); 
} 


void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast()); 
    if (characteristicP->getUUID().getShortUUID() == 0x2a37) { /* !ALERT! Alter this filter to suit your device. */ 
        characteristicP->read(0);
        ledCharacteristic        = *characteristicP; 
        triggerLedCharacteristic = true; 
    } 
} 


void discoveryTerminationCallback(Gap::Handle_t connectionHandle) { 
    printf("terminated SD for handle %u\r\n", connectionHandle); 
    if (triggerLedCharacteristic) { 
        triggerLedCharacteristic = false; 
        eventQueue.call(updateLedCharacteristic); 
    } 
} 


void connectionCallback(const Gap::ConnectionCallbackParams_t *params) { 
    printf("connectionCallback\r\n");
     if (params->role == Gap::CENTRAL) {
         printf("Gap::CENTRAL\r\n"); 
         BLE &ble = BLE::Instance(); 
         ble.gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
         ble.gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback/*, 0xa000, 0xa001*/); 
     }
}  

 void triggerRead(const GattWriteCallbackParams *response) { 
    printf("triggerRead\r\n");
     if (response->handle == ledCharacteristic.getValueHandle()) { 
         ledCharacteristic.read(); 
     } 
 } 
 

 void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *) { 
     printf("disconnected\r\n"); 
     /* Start scanning and try to connect again */ 
     BLE::Instance().gap().startScan(advertisementCallback); 
 } 
 

 void onBleInitError(BLE &ble, ble_error_t error) 
 { 
    /* Initialization error handling should go here */ 
 } 
 

 void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
 { 
     BLE&        ble   = params->ble; 
     ble_error_t error = params->error; 
 
    printf("Init_1\r\n");

     if (error != BLE_ERROR_NONE) { 
         /* In case of error, forward the error handling to onBleInitError */ 
         onBleInitError(ble, error); 
         return; 
     } 
 
    printf("Init_2\r\n");

     /* Ensure that it is the default instance of BLE */ 
     if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) { 
         return; 
     } 
 

     ble.gap().onDisconnection(disconnectionCallback); 
     ble.gap().onConnection(connectionCallback); 
 

     ble.gattClient().onDataRead(triggerToggledWrite); 
     ble.gattClient().onDataWrite(triggerRead); 
 

     // scan interval: 400ms and scan window: 400ms. 
     // Every 400ms the device will scan for 400ms 
     // This means that the device will scan continuously. 
     ble.gap().setScanParams(400, 400); 
     ble.gap().startScan(advertisementCallback); 
 } 
 

 void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) { 
     BLE &ble = BLE::Instance(); 
     eventQueue.call(Callback<void()>(&ble, &BLE::processEvents)); 
 } 
 

 int main() 
{
    uart.baud(115200);
    printf("main_1\r\n");
    triggerLedCharacteristic = false;
    eventQueue.call_every(1000, periodicCallback); 
 
    printf("main_2\r\n");
    BLE &ble = BLE::Instance(); 
    ble.onEventsToProcess(scheduleBleEventsProcessing); 
    ble.init(bleInitComplete); 
    printf("main_3\r\n");

    eventQueue.dispatch_forever(); 

    printf("main_4\r\n"); 

    return 0; 
} 