/**
 *  @file main.cpp
 *  uTerminal_Example is a simple example demonstrating how to 
 *  use the uTerminal library.
 *
 *  @author  Fernando Cosentino
 */

#include "mbed.h"
#include "uTerminal.h"

//================================================================
// INSTANCING THE TERMINAL:

/*
// Create a Serial object yourself
Serial pc(P0_19, P0_18); // TX, RX pins for board n-DAP
uTerminal terminal(&pc); // argument is the address of a Serial object
*/

// or...
// This will automatically create an internal Serial object
//uTerminal terminal(P0_19, P0_18); // TX, RX pins for board n-DAP

// or...
// Create a USBSerial object yourself (works with blocking and non-blocking)
//USBSerial pc; // blocking
USBSerial pc(0x1f00, 0x2012, 0x0001, false); // non-blocking
uTerminal terminal(&pc); // argument is the address of a USBSerial object

//================================================================


char sbuf[1024]; // useb by sprintf

/**
 *  Callback called to process a message received by uTerminal
 *  If Auto-mode is used, this is called whenever a message arrives.
 *  Otherwise, called whenever termina.Process() is polled.
 */
 
void msg_received() {
    int i;

    terminal.print("Received:\n");
    terminal.print(terminal.Command);
    terminal.print(" = ");
    terminal.print(terminal.Value);
    terminal.print("\n");
    
    sprintf(sbuf, "NumParams: %d\n", terminal.NumParams);
    terminal.print(sbuf);
    
    for (i=0; i<terminal.NumParams; i++) {
        sprintf(sbuf, "Param %d = ", i);
        terminal.print(sbuf);
        terminal.GetParam();
        terminal.print(terminal.Param);
        terminal.print("\n");
    }
}


/**
 * Main loop
 */
int main() {
    
    // Attach the callback. This is optional, you can inspect the
    // member objects Command, Value and Param from anywhere.
    // But this is convenient
    terminal.attach(&msg_received);
    
    // Uncomment below for auto-mode (fires interrupt whenever there is a message)
    terminal.ModeAuto();
    
    // Uncomment below for manual mode (polled)
    //terminal.ModeManual(); // optional since default is manual mode

    // Warn user the program is running
    terminal.print("\nInitialised!\n\n");

    while(1) {
        /*
        // Polled (manual) version:
        if (terminal.Process()) {
            // you can actually call msg_received() from here yourself,
            // if the callback feature is not used.
            terminal.print("Processed!\n");
        }
        */
    }
}
