/**
 *  @file ADS1231_GP.h
 *  ADS1231 General Purpose library to deal with ADS1231 AD Converter
 *
 *  @author Fernando Cosentino
 *  Nimbus Centre
 *  Cork Institute of Technology
 *  fernando.cosentino@cit.ie
*/

#ifndef __ADS1231_GP
#define __ADS1231_GP

#include "mbed.h"

/**
 *  ADS1231_GP Class
 * 
 *  @author Fernando Cosentino
 */
class ADS1231_GP {
public:
    /**
     *  Creates an instance. This version does not support speed changes
     *  (speed must be hard-wired or controlled externally).
     *
     *  @param doutPin Pin connected to data out (!DRDY/DOUT) from ADS1231
     *  @param clkPin Pin connected to serial clock (SCLK) to ADS1231
     *  @param pdwnPin Pin connected to power down (!PDWN) to ADS1231
     */
    ADS1231_GP(PinName doutPin, PinName clkPin, PinName pdwnPin);
    
    /**
     *  Sets power ON or OFF to ADS1231.
     *
     *  @param p Boolean indicating power down. 1=OFF, 0=ON
     */
    void setPower(unsigned int p);
    
    /**
     *  Checks if data is available to be read.
     * 
     *  @returns 1 if ADS1231 is ON and data is available, 0 otherwise.
     */
    unsigned int dataAvailable(void);
    
    /**
     *  Reads a value from ADS1231 output. You must first ensure there is data
     *  available using dataAvailable().
     *
     *  @returns Raw data read as unsigned int
     */
    unsigned int readValue(void);
private:
        DigitalIn dout;
        DigitalOut clk;
        DigitalOut pdwn;

};






#endif                   