/*
  ADS1231 General Purpose library
  Fernando Cosentino
  Nimbus Centre
  Cork Institute of Technology
  fernando.cosentino@cit.ie
*/

#include "ADS1231_GP.h"

ADS1231_GP::ADS1231_GP(PinName doutPin, PinName clkPin, PinName pdwnPin): dout(doutPin), clk(clkPin), pdwn(pdwnPin) {
    pdwn = 0;
}

void ADS1231_GP::setPower(unsigned int p) {
    pdwn = p;
}

unsigned int ADS1231_GP::dataAvailable(void) {
    if (pdwn == 0) return 0;
    if (dout == 0) return 1;
    else return 0;
}

unsigned int ADS1231_GP::readValue(void) {
    unsigned int val = 0;
    int i;
    // Extract 24 bits of data
    for (i = 0; i < 24; i++) {
        // CLK rise
        clk = 1;
        // Wait CLK up
        wait_us(1);
        // Sample
        val = val << 1;
        if (dout != 0) val |= 1;
        // CLK fall
        clk = 0;
        // wait CLK down
        wait_us(1);
    }
    // Apply 25th CLK to force DOUT back into IRQ function
    clk = 1;
    wait_us(1);
    clk = 0;
    wait_us(1);
    // Return data
    return val;
}