#include "mylibs/globais.h"
#include "sample_handler.h"

// TODO: Deixar o construtor genérico para vários ADCs
SampleHandler::SampleHandler(PinName adc_pin):this_adc(adc_pin){
    // Aqui o certo é criar o objeto e depois passar a referência para o objeto da classe
    
    AnalogIn ain(adc_pin);
    this_adc = ain;   
    is_buffer_filled = false;
    sp_rdy = false;
    tr_rdy = false;
    start_transfer = false;
    one_sample_readout = 0.0;
    is_sampled = false;
    position = 0;
    
    uint16_t local_counter = 0;
    for (local_counter = 0; local_counter < BUFFER_SIZE; local_counter = local_counter + 1) {
        sampling_buffer[local_counter] = 0;
    }
}

void SampleHandler::get_sample(void){
    is_sampled = false;
    one_sample_readout = float(ADC_VREF)*this_adc.read(); // sem a multiplicação por ADC_VREF, chega-se a picos de 62500 Hz
    is_sampled = true;
}


void SampleHandler::get_buffer(void){
    static uint16_t static_local_counter = 0;
    sampling_buffer[static_local_counter] = one_sample_readout;
    static_local_counter = static_local_counter + 1;
    
    if (static_local_counter == BUFFER_SIZE - 1){
        static_local_counter = 0;
        //return true;    
    }else{
        //return false;    
    }
}
