/*  Autor: Fávero Santos
    Localização: Curitiba, Paraná
    Data: 11/01/2018
    Informações:
*/

#ifndef SAMPLE_HANDLER_H
#define SAMPLE_HANDLER_H

#include "mylibs/globais.h"


class SampleHandler{
    private:
        AnalogIn this_adc;
        bool sp_rdy;
        bool tr_rdy;
        bool start_transfer;
        bool is_sampled;
        uint16_t position;
               
    public:
        float one_sample_readout;
        float sampling_buffer[BUFFER_SIZE];
        bool is_buffer_filled;
        
        SampleHandler(PinName adc_pin);
        AnalogIn get_sampler(void);
        
        void start_buffering(void);
        void get_sample(void);
        void get_buffer(void);
};

#endif