#include "mylibs/globais.h"
#include "sample_handler.h"
#include "EthernetInterface.h"
#include "string.h"
#include "rtos.h"
#include "mbed.h"
#include "LPC407x_8x_177x_8x.h"
#include "system_LPC407x_8x_177x_8x.h"
#include <iostream>

typedef struct ethernet_handler_s{
    int n_written;
} my_ethernet_handler_t;

/* Instanciar objetos */
SampleHandler my_sample_handler(p15);
my_ethernet_handler_t my_ethernet_handler;

DigitalOut led_verde_1(LED1);
DigitalOut led_verde_2(LED2);
DigitalOut my_pin(p8);

Thread adc_thread;
Thread transfer_thread;
EthernetInterface eth;
TCPSocketConnection sock;

Serial serial_debug(USBTX, USBRX);
Ticker ticker_sampler;
Timer benchmark;


/* Funções */
void conf_serial_debug(void);
void conf_ethernet(void);
void conf_thread(void);
void conf_timer(void);

void adc_thread_launch(void);
void sample_int(void);
void transfer_int(void);
void print_readout(void);
void adc_sample_now(void);
void sample_now(void);
void flip(void);

bool sampled = false;

int main() {
    my_ethernet_handler.n_written = 9;
    conf_serial_debug();
    serial_debug.printf("\033[2J"); // Limpa tela, em ANSI
    serial_debug.printf("\033[H");  // Cursor para home
    serial_debug.printf("\r -- Aloha!! \n");
    //conf_ethernet();
    //serial_debug.printf("\r -- Ethernet OK!! \n");
    //conf_thread();
    //serial_debug.printf("\r -- Thread OK!! \n");
    conf_timer();
    serial_debug.printf("\r -- Timer OK!! \n");   


       
    led_verde_1 = 0;
    led_verde_2 = 1;
    my_pin = 0;
        
    while(1) {
        my_pin = !my_pin;
        
        /*if (sampled == true){
            sampled = false;
            serial_debug.printf("\r -- Frequencia de amostragem (Hz): %f \n", 1/benchmark.read());
            benchmark.reset();
            my_pin = 1;
        }*/
        //adc_thread.signal_set(0x1);
        /*if (my_ethernet_handler.n_written == -1){
            sock.close();
            serial_debug.printf("\r -- Socket closed!\n");
            
            eth.disconnect();
            serial_debug.printf("\r -- Ethernet disconnected!\n");
            break;
        }*/
    }
    //serial_debug.printf("\r -- Programa em loop infinito!\n");
    //while(1){}
}

void print_readout(void){
    serial_debug.printf("\r -- Valor de sample: %f \n", my_sample_handler.one_sample_readout);  
}

void sample_int(void){
    static uint16_t static_local_counter = 0;
    while(1){
        //benchmark.start();
        //Thread::wait(1);
        Thread::signal_wait(0x1);
        my_sample_handler.get_sample();
        
        //Thread::signal_wait(0x1);


        /*my_sample_handler.sampling_buffer[static_local_counter] = my_sample_handler.one_sample_readout;
        //print_readout();
        //serial_debug.printf("\r -- Posicao do buffer: %d \n", static_local_counter); 
        static_local_counter = static_local_counter + 1;
        
        if (static_local_counter == BUFFER_SIZE){
            static_local_counter = 0;
            my_sample_handler.is_buffer_filled = true;    // aqui era true 
            transfer_thread.signal_set(0x1);
            //serial_debug.printf("\r -- ADC_THREAD_SIGNAL: 1 \n");
        }*/
        //benchmark.stop();
        //serial_debug.printf("\r -- Frequencia de amostragem (Hz): %f \n", 1/benchmark.read());
        //benchmark.reset();
    }
}

void transfer_int(void){
    uint16_t x;
    std::string str;
    char * gigante = (char *)calloc(BUFFER_SIZE * 8, sizeof(char)); //BUFFER_SIZE * 32, sizeof(char)
    char tmp[8];
    
     while(1) {
       Thread::signal_wait(0x1);
       led_verde_1 = !led_verde_1;
       if (my_sample_handler.is_buffer_filled == true){
            my_sample_handler.is_buffer_filled = false;
            
            str += "i\t"; 
            for (x = 0; x < BUFFER_SIZE; x++) {
                if (my_sample_handler.sampling_buffer[x] < 0)
                {
                    my_sample_handler.sampling_buffer[x] = 0;
                }
                //memset(tmp, 0, sizeof(tmp));
                sprintf(tmp, "%f\t", my_sample_handler.sampling_buffer[x]);
                str += tmp;
            }
            str += "f\n";

            std::strcpy(gigante, str.c_str());
            my_ethernet_handler.n_written = sock.send_all(gigante, BUFFER_SIZE*9+4);
            str.clear();
            if(my_ethernet_handler.n_written == -1){
                
                // TODO Não está funcionando esse clean close aqui
                transfer_thread.terminate();
                serial_debug.printf("\r -- Thread de transferencia terminada!\n");
                break;
            }
        }
    }
}

void conf_serial_debug(void){
    serial_debug.baud(921600);
}

void conf_thread(void){
    adc_thread.start(sample_int); 
    transfer_thread.start(transfer_int);
}

void adc_thread_launch(void){
    adc_thread.signal_set(0x1);
    serial_debug.printf("\r -- Tock!!\n");
}

void sample_now(void){
    //serial_debug.printf("\r -- Tick!!\n");
    my_pin = 0;
    sampled = true;
    //benchmark.start();
    my_sample_handler.get_sample();
    //benchmark.stop();
    //serial_debug.printf("\r -- Frequencia de amostragem (Hz): %f \n", 1/benchmark.read());
    //benchmark.reset();
    //my_pin = !1;
}

void flip(void){
    led_verde_1 = !led_verde_1;
    led_verde_2 = !led_verde_2;
    //serial_debug.printf("\r -- Tick!!\n");
}

void conf_timer(void){
    /*ticker_sampler.attach_us(&sample_now,100);
    serial_debug.printf("\r -- Tock!!\n");*/
}

void conf_ethernet(void){
    int16_t is_connected = 9;
    
    /* Ethernet init */
    eth.init("192.168.201.59", "255.255.255.0", "192.168.201.253");
    serial_debug.printf("\r -- Mac Address is: %s \n", eth.getMACAddress());
    
    is_connected = eth.connect(); 
    if (is_connected == 0){
        serial_debug.printf("\r -- Connection OK!! \n");
    }else if (is_connected != 0){
        serial_debug.printf("\r -- Connect NOK!! \n");
        serial_debug.printf("\r -- Error code: %d\n", is_connected);
    }
    serial_debug.printf("\r -- IP Address is: %s \n", eth.getIPAddress());
    serial_debug.printf("\r -- Mask Address is: %s \n", eth.getNetworkMask());
    serial_debug.printf("\r -- Gateway Address is: %s \n", eth.getGateway());
    
    /* Socket init */
    while (sock.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        serial_debug.printf("\r -- Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    serial_debug.printf("\r -- Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
}