/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_IMU_SERVICE_H__
#define __BLE_IMU_SERVICE_H__

class ImuService {
public:
    const static uint16_t IMU_SERVICE_UUID              = 0xA000;
    const static uint16_t IMU_STATE_CHARACTERISTIC_UUID = 0xA001;

    ImuService(BLE &_ble, int16_t* initAcc) :
        ble(_ble),
        acceleration(IMU_STATE_CHARACTERISTIC_UUID,
                    initAcc,
                    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&acceleration};
        GattService imuService(ImuService::IMU_SERVICE_UUID,
                                  charTable,
                                  sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(imuService);
    }

    void updateImuState(int16_t newState[3]) {
//        printf("acc: %d, %d, %d\r\n", newState[0], newState[1], newState[2]);
        uint8_t val[6];
        val[0] = (newState[0] & 0xFF00) >> 8; val[1] = newState[0] & 0xFF;
        val[2] = (newState[1] & 0xFF00) >> 8; val[3] = newState[1] & 0xFF;
        val[4] = (newState[2] & 0xFF00) >> 8; val[5] = newState[2] & 0xFF;
//        printf("acc x: %x-%x-%x-%x\r\n", val[0], val[1], val[2], val[3]);
        ble.gattServer().write(acceleration.getValueHandle(),
                               val,
                               6);
//        printf("acc x: %x-%x-%x-%x\r\n", val[0], val[1], val[2], val[3]);
    }

private:
    BLE                                   &ble;
    ReadOnlyArrayGattCharacteristic<int16_t, 3>  acceleration;
};

#endif /* #ifndef __BLE_IMU_SERVICE_H__ */
