#include "mbed.h"
#include "MAX7456.h"

namespace mbed {



MAX7456::MAX7456(PinName mosi, PinName miso, PinName clk, PinName ncs, PinName nrst, const char* name)
        : Stream(name), _spi(mosi, miso, clk), _ncs(ncs),_nrst(nrst){

// initialisation code here

    _nrst = 0;
    wait (0.5);
    _nrst = 1;
    wait (0.5);

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture
    _spi.format(8,0);

    // 1MHz clock
    _spi.frequency(1000000);
}


void MAX7456::cls() {
    int tmp=0;
    tmp = _read(DMM);
    tmp &= 0xFB;
    _write(DMM,tmp);  //Make sure that DMM[2]=0 so that there can be write operations

    tmp = _read(DMM);
    tmp |= 0x04;
    _write (DMM,tmp);   //set DMM[2]=1 to clear all locations

    // should wait until DMM[2] goes back to zero, so we know the reset it finished

}

/*
void MAX7456::show(){
   _write(DMAL,0x1e); // location (0,1)
   _write(DMDI,0x21); // writing the charater address "W" into DMDI 

   _write(DMAL,0x1f); // location (0,1)
   _write(DMDI,0x19); // writing the charater address "O" into DMDI 

   _write(DMAL,0x20); // location (0,1)
   _write(DMDI,0x1C); // writing the charater address "R" into DMDI 

   _write(DMAL,0x21); // location (0,1)
   _write(DMDI,0x16); // writing the charater address "L" into DMDI 

   _write(DMAL,0x22); // location (0,1)
   _write(DMDI,0x0E); // writing the charater address "D" into DMDI  0x0E
   } 
*/

int MAX7456::_getc() {    
    int mode= _read(DMM);
    mode|=0x01;
    _write(DMM,mode);
   return(0);
}
void MAX7456::test(){
   for (int i = 0 ; i < 255 ; i++) {
       printf("Writing 0x%x to VM1\n",i);
       _write(VM1,i);
       wait (0.01);
       int a = _read(VM1);
       printf("Read 0x%x from VM1\n",a);       
   }
   int b = _read(VM1);
   printf("Read 0x%x from VM1\n",b);
   }

void MAX7456::locate(int x, int y) { 
    if ( (x<30) && (y<16) ) {
        int add = y*30+x; //formula for converting coordinates into denary location
        _write(DMAL,add);
        _write(DMAH,add>>8); // what does the ">>" mean?
    }
     printf("location %d",x);
}


void MAX7456::xyincrement(){ // increment starts here
    int x=0;
    int y=0;
    while (x<31&&y<=16){
        x=x+1;
        if (x>30){
        y=y+1;
        x=0;
        }
        locate(x,y);
    }
}

    

int MAX7456::_putc(int c) {
    int set= _read(DMM);
    set&=0xFB;           //set bit 1 to 0 so that the DMM register can be written to
    _write(DMM,set);  

    
    if ((c >= 0x31)&&(c <= 0x39)) { //characters from 1-9
        c= c-0x30;
    } 
    else if ((c >= 0x41)&&(c <= 0x5A)) { // characters from A-Z
        c= c-0x36;
    } 
    else if ((c >= 0x61)&&(c <= 0x7A)) { // characters from a-z
        c= c-0x3C;
    } 
    else if ((c == 0x28)&&(c == 0x29)) { //brackets ()
        c= c + 0x17;
    }

    _write(DMDI,c);
    
    /*
    int mode= _read(DMM);
    mode|=0x01;        // enable auto increment mode
    _write(DMM,mode);
    _HYSNC=1;
    */
    //xyincrement();
    
    /*
    int data= _read(DMDI);
    printf("DMDI shows 0x%x",data);
    */
    
    return(c);
 
}

void MAX7456::setdarkness() {
    _write(VM1,0xC7);
}

void MAX7456::invert(int bit) {
    int data= _read(DMM);
    if (bit == 1){
        data|=0x08;
        }
    else if (bit == 0){
        data&=0xF9;
        }
    _write(DMM,data);
    }
        


void MAX7456::initaddress() {
    int d = _read(DMAH);
    d= d&0xFC;
    _write(DMAH,d);     // setting DMAH[1]=0
    // to module to read/write character address byte
}



//   write(HOS,0x2F);
//   write(VOS,0x17);
void MAX7456::vtrim(char way, int v) {
    if (way=='+'){
        v=~v;
        _write(VOS,v);
        }
    else{
        v|=0x10;
        _write(VOS,v);
        }        
}

void MAX7456::htrim(char way, int h) {
    if (way=='-'){
        h=~h;
        _write(HOS,h);
        }
    else{
        h|=0x20;
        _write(HOS,h);
        }     
}



void MAX7456::format (char mode) {

    if (mode == 'P') {
        _write(VM0,0x78);  // PAL
    } else if (mode == 'N') {
        _write(VM0,0x78);  // NTSC
    }

}

int MAX7456::_read(int address) {
// force bit 7 to 1 for a read
    address |= 0x80;
    _ncs=0; // select device
    _spi.write(address);          // send address
    int value = _spi.write(0x00); // send dummy
    _ncs=1; //deselect device
    return (value);
}

void MAX7456::_write(int address, int data) {
    // force bit 7 to 0 for a write
    address &= 0x7f;
    // select the device
    _ncs = 0;
    // write VM1
    _spi.write(address); // send address
    _spi.write(data); // send some data
    // Deselect the device
    _ncs = 1;
}

}