#include "mbed.h"
#include "MAX7456.h"

namespace mbed {



MAX7456::MAX7456(PinName mosi, PinName miso, PinName clk, PinName ncs, PinName nrst, const char* name)
        : Stream(name), _spi(mosi, miso, clk), _ncs(ncs), _nrst(nrst) {
                                
// initialisation code here

   _nrst = 0;   
   wait (0.5);   
   _nrst = 1;   
   wait (0.5);

   // Setup the spi for 8 bit data, high steady state clock,
   // second edge capture
   _spi.format(8,0);

   // 1MHz clock
   _spi.frequency(1000000);


}




void MAX7456::cls() {
    int tmp=0;
    tmp = _read(DMM);
    tmp &= 0xFB;
    _write(DMM,tmp);  //Make sure that DMM[2]=0 so that there can be write operations

    tmp = _read(DMM);
    tmp |= 0x04;
    _write (DMM,tmp);   //set DMM[2]=1 to clear all locations

    // should wait until DMM[2] goes back to zero, so we know the reset it finished

}


void MAX7456::locate(int x, int y) { //not sure if I understand the last line
    if ( (x<30) && (y<16) ) {
        int add = y*30+x; //formula for converting coordinates into denary location
        _write(DMAL,add);
        _write(DMAH,add>>8); // what does the ">>" mean?
    }
}



int MAX7456::_getc(int character) {
    for (int i = 0 ; i < 479 ; i++) { 
        int location= _read(DMDI,i)
        
        if((location == character - 0x30){ //characters from 1-9
            found= "true";
            }
        else if(location == character - 0x36){ // characters from A-Z
            found = "true";
            }
        else if(location == character - 0x3C){ // characters from a-z
            found = "true";
            }
        else if(location == character + 0x17){ //brackets ()
            found = "true";
            }    
        else{
            found = "false";
        
        if found = "true"{
            return(i);
            }
        else{
            return("character not found");
    }
}


int MAX7456::_putc(int c) {
    
    if((c >= 0x31)&&(c <= 0x39)) { //characters from 1-9
        c= c-0x30;
        }
    if((c >= 0x41)&&(c <= 0x5A)){ // characters from A-Z
        c= c-0x36;
        }
    if((c >= 0x61)&&(c <= 0x7A)){ // characters from a-z
        c= c-0x3C;
        }
    if((c == 0x28)&&(c == 0x29)){ //brackets ()
        c= c + 0x17;
        }    
    _write(DMDI,c);
    return(c);
}




void MAX7456::vtrim(int v) {
}

void MAX7456::htrim(int h) {
}

void MAX7456::format(char mode){
    if (mode == "P"){
        write(VM0,0x78);  // internal sync, OSD enable, PAL
        }
}        

int MAX7456::_read(int address) {
 // force bit 7 to 1 for a read
    address |= 0x80;
    _ncs=0; // select device
    _spi.write(address);          // send address
    int value = _spi.write(0x00); // send dummy
    _ncs=1; //deselect device
    return (value);
}

void MAX7456::_write(int address, int data) {
   // force bit 7 to 0 for a write
   address &= 0x7f;
   // select the device
   _ncs = 0;
   // write VM1    
   _spi.write(address); // send address
   _spi.write(data); // send some data
   // Deselect the device
   _ncs = 1; 
}
