/* MPU9250 Basic Example Code
 by: Kris Winer
 date: April 1, 2014
 license: Beerware - Use this code however you'd like. If you
 find it useful you can buy me a beer some time.

 Demonstrate basic MPU-9250 functionality including parameterizing the register addresses, initializing the sensor,
 getting properly scaled accelerometer, gyroscope, and magnetometer data out. Added display functions to
 allow display to on breadboard monitor. Addition of 9 DoF sensor fusion using open source Madgwick and
 Mahony filter algorithms. Sketch runs on the 3.3 V 8 MHz Pro Mini and the Teensy 3.1.

 SDA and SCL should have external pull-up resistors (to 3.3V).
 10k resistors are on the EMSENSR-9250 breakout board.

 Hardware setup:
 MPU9250 Breakout --------- Arduino
 VDD ---------------------- 3.3V
 VDDI --------------------- 3.3V
 SDA ----------------------- A4
 SCL ----------------------- A5
 GND ---------------------- GND

 Note: The MPU9250 is an I2C sensor and uses the Arduino Wire library.
 Because the sensor is not 5V tolerant, we are using a 3.3 V 8 MHz Pro Mini or a 3.3 V Teensy 3.1.
 We have disabled the internal pull-ups used by the Wire library in the Wire.h/twi.c utility file.
 We are also using the 400 kHz fast I2C mode by setting the TWI_FREQ  to 400000L /twi.h utility file.
 */
//yellow  SCL on PB6
//Green SDA on PB7
//brown 3,3V
//black GND
#include "MPU9250.h"
#include "FLASH.h"
#include "user.h"

MPU9250 mpu9250;

void Read_MPU9250()
{
    myled= !myled;
    // If intPin goes high, all data registers have new data
        if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {  // On interrupt, check if data ready interrupt

            mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values
            // Now we'll calculate the accleration value into actual g's
            
            ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
          // printf("ax=%f\n\r",ax);
        // printf ("accelcount=%x\n\r",accelCount[0]);
              //    printf ("accelcount int=%i\n\r",accelCount[0]);
           //printf ("acc X_H=%x\n\r",reg8_bit[X_H]);
           // printf ("acc decimel X_L=%d\n\r",reg8_bit[X_L]);
           // printf ("acc X_L=%x\n\r",reg8_bit[X_L]);
           /* ay = (float)accelCount[1]*aRes - accelBias[1];
            az = (float)accelCount[2]*aRes - accelBias[2];
            */
            mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
            // Calculate the gyro value into actual degrees per second
            /*
            gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
            gy = (float)gyroCount[1]*gRes - gyroBias[1];
            gz = (float)gyroCount[2]*gRes - gyroBias[2];
            */
            mpu9250.readMagData(magCount);  // Read the x/y/z adc values
            // Calculate the magnetometer values in milliGauss
            // Include factory calibration per data sheet and user environmental corrections
            /*
            mx = (float)magCount[0]*mRes*magCalibration[0] - magbias[0];  // get actual magnetometer value, this depends on scale being set
            my = (float)magCount[1]*mRes*magCalibration[1] - magbias[1];
            mz = (float)magCount[2]*mRes*magCalibration[2] - magbias[2];
            */
            myled= !myled;
        }
    
    }






float sum = 0;
uint32_t sumCount = 0;


Ticker every_10ms;
Timer t;

Serial pc(USBTX, USBRX); // tx, rx


int main()
{
    pc.baud(9600);
    SER_FLASH.frequency(1000000);
    FLASH_CS=1;

    SER_FLASH_ERASE();
    wait(3);
// while(1)
    //{
    wait(.5);

//}
    //Set up I2C
    i2c.frequency(1000000);  // use fast (400 kHz) I2C

    //pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);

    t.start();

 pc.printf("start...\n\r");

    // Read the WHO_AM_I register, this is a good test of communication
    uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);  // Read WHO_AM_I register for MPU-9250
    pc.printf("I AM 0x%x\n\r", whoami);
    pc.printf("I SHOULD BE 0x71\n\r");

    if (whoami == 0x71) { // WHO_AM_I should always be 0x68
       pc.printf("MPU9250 is online...\n\r");
        wait(1);


        mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
        mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers
       /*
        pc.printf("x gyro bias = %f\n\r", gyroBias[0]);
        pc.printf("y gyro bias = %f\n\r", gyroBias[1]);
        pc.printf("z gyro bias = %f\n\r", gyroBias[2]);
        pc.printf("x accel bias = %f\n\r", accelBias[0]);
        pc.printf("y accel bias = %f\n\r", accelBias[1]);
        pc.printf("z accel bias = %f\n\r", accelBias[2]);*/
        wait(2);
        mpu9250.initMPU9250();
       // pc.printf("MPU9250 initialized for active data mode....\n\r"); // Initialize device for active mode read of acclerometer, gyroscope, and temperature
        mpu9250.initAK8963(magCalibration);
       // pc.printf("AK8963 initialized for active data mode....\n\r"); // Initialize device for active mode read of magnetometer
        //pc.printf("Accelerometer full-scale range = %f  g\n\r", 2.0f*(float)(1<<Ascale));
        //pc.printf("Gyroscope full-scale range = %f  deg/s\n\r", 250.0f*(float)(1<<Gscale));
       // if(Mscale == 0) pc.printf("Magnetometer resolution = 14  bits\n\r");
        //if(Mscale == 1) pc.printf("Magnetometer resolution = 16  bits\n\r");
        //if(Mmode == 2) pc.printf("Magnetometer ODR = 8 Hz\n\r");
        //if(Mmode == 6) pc.printf("Magnetometer ODR = 100 Hz\n\r");
      //  MPU9250SelfTest();
        wait(2);
    } else {
        pc.printf("Could not connect to MPU9250: \n\r");
        pc.printf("%#x \n",  whoami);



        while(1) ; // Loop forever if communication doesn't happen
    }

    mpu9250.getAres(); // Get accelerometer sensitivity
    //mpu9250.getGres(); // Get gyro sensitivity
    //mpu9250.getMres(); // Get magnetometer sensitivity
    //pc.printf("Accelerometer sensitivity is %f LSB/g \n\r", 1.0f/aRes);
    //pc.printf("Gyroscope sensitivity is %f LSB/deg/s \n\r", 1.0f/gRes);
    //pc.printf("Magnetometer sensitivity is %f LSB/G \n\r", 1.0f/mRes);
    magbias[0] = +470.;  // User environmental x-axis correction in milliGauss, should be automatically calculated
    magbias[1] = +120.;  // User environmental x-axis correction in milliGauss
    magbias[2] = +125.;  // User environmental x-axis correction in milliGauss
    wait(2);
every_10ms.attach(&Read_MPU9250, 10);//0.001

    while(1) {
            
           // Read_MPU9250();
        


            /*******************************memory write and read***************************************/
            write_EN_Flash();
            FLASH_CS=0;
            SER_FLASH.write(write_EN);
            FLASH_CS=1;

            FLASH_CS=0;
            SER_FLASH.write(page_prog);
            SER_FLASH.write(0x00); //page adress
            SER_FLASH.write(0x00);//page adress
            SER_FLASH.write(0x00);//page adress
            //LED_Green=0;
            for (int i=0; i<=255; i++) {
                Sensor_data[i]=255-i;
                //pc.printf("array filling %i=%i\n\r", i,Sensor_data[i]);
            }
            int b= SER_FLASH.write(&Sensor_data[0],255,&SPI_rec[0],0);
            FLASH_CS=1;
            pc.printf("number of bytes=%i\n\r", b);


            FLASH_CS=0;
            SER_FLASH.write(Read_Data);
            SER_FLASH.write(0x00); //page adress
            SER_FLASH.write(0x00);//page adress
            SER_FLASH.write(0x00);//page adress



            for(int i=0; i<=255; i++) {
                Sensor_data[i]= SER_FLASH.write(0x00);
                //pc.printf("location %i=%i\n\r",i, Sensor_data[i]);
            }
            FLASH_CS=1;

            /***********************************************************************************************************/
       // while(1);

            wait(1);
  //      }
    }

}



