#include "mbed.h"
#include "Commands.h"

#define COMMAND_MAX_SIZE 30

char command[COMMAND_MAX_SIZE];
int cmdIndex;
int commandReady;

CommandList commands;
Serial pc(USBTX, USBRX);

// This function is called when a character goes into the RX buffer.
void rxCallback() {
    char c;
    c = pc.getc();
    
    if(c != '\n')
    {
        command[cmdIndex++] = c;
        command[cmdIndex] = 0;
    }
    
    if(cmdIndex == COMMAND_MAX_SIZE ||  c == '\r')
    {
        command[cmdIndex-1] = 0;
        commandReady = 1;
        cmdIndex = 0;
    }
}

void parseServo(CommandArgs cmdArgs)
{
    if(cmdArgs.paramCount != 3)
        printf("command %s: wrong parameters count\r\n", cmdArgs.params[0]);
        
    printf("servo: %s %s\r\n",cmdArgs.params[1], cmdArgs.params[2]);
}

void parseUnknown(CommandArgs cmdArgs)
{
    printf("Unknown command '%s'\r\n", cmdArgs.params[0]);
}

int main()
{
    cmdIndex = 0;
    commandReady = 0;
        
    commands.add("unknown",parseUnknown);
    commands.add("servo",parseServo);

    pc.printf("Enter Command:\r\n");
    pc.attach(&rxCallback, Serial::RxIrq);
    
    while(1)
    {
        if(commandReady)
        {
            commands.parseCommand(command);
            commandReady = 0;
        }    
    }
}
