

//Dimiter Kentri update


/*	 Copyright (c) 2010 Dimiter Kentri

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "keypad3x4.h"

using namespace mbed;

Keypad::Keypad(PinName col1,PinName col2,PinName col3,PinName row1,PinName row2,PinName row3,PinName row4):_col1(col1),_col2(col2),_col3(col3),_rows(row1,row2,row3,row4)    
{    
	_col1.mode(PullUp);
	_col2.mode(PullUp);
	_col3.mode(PullUp);      
}     

int Keypad::getKeyIndex()
{
    _rows = 0;   
    for(int i=0; i<4; i++) 
    {
        _rows = 1 << i;     
	    for(int j=0; j<4;j++)
	    {         
        	if (_col1)
          		return 1+(i*3);
    		else if (_col2)
                return 2+(i*3);
            else if (_col3)
                return 3+(i*3);            
        }
    }    
    return 11;
}          

char Keypad::getKey()
{
	int k = getKeyIndex();    
	if(k != 11)
    	return  keys[k-1];
 	else 
 		return 0;
}
