#ifndef WAVEGEN_H
#define WAVEGEN_H

#include "mbed.h"

namespace mbed
{
    class WaveGen
    {
        public:
            WaveGen(PinName WaveForm);
            
            /*********************************************************************
            
            Questa funzione gestisce la generazione della forma d'onda sinusoidale
            
            *********************************************************************/
            void SineWave(float Frequency, float Amplitude);
            
            /*********************************************************************
            
            Questa funzione gestisce la generazione della forma d'onda quadra
            
            *********************************************************************/
            void SquareWave(float Frequency, float Amplitude, float DutyCycle);
            
            /*********************************************************************
            
            Questa funzione gestisce la generazione della forma d'onda triangolare
            
            *********************************************************************/
            void TriangularWave(float Frequency, float Amplitude);
            
            /*********************************************************************
            
            Questa funzione gestisce la generazione della forma d'onda a dente di
            sega
            
            *********************************************************************/
            void SawToothWave(float Frequency, float Amplitude);
            
            /*********************************************************************
            
            Questa funzione gestisce il calcolo del periodo e la divisione di 
            questo in intervalli di tempo durante il quale tenere stabile 
            un valore di tensione
            
            *********************************************************************/
            int TCalc(int div, float Freq);
            
            /*********************************************************************
            
            Questa funzione adatta il valore di tensione fornito alle specifiche 
            della funzione che gestisce il DAC
            
            *********************************************************************/
            float VCalc(float Volt);
            
            /*********************************************************************
            
            Questa funzione la conversione da gradi a radianti
            
            *********************************************************************/
            float RadCalc(float Ang);
        protected:
            AnalogOut _WaveForm;    
    };    
}

#endif