#include "mbed.h"
#include "WaveGen.h"

using namespace mbed;

WaveGen::WaveGen(PinName WaveForm):_WaveForm(WaveForm)
{
    _WaveForm.write(0);   
}

int WaveGen::TCalc(int div,float Freq)
{
    float temp = 0;
    if(div == 0)   
    {
        temp = 1 / Freq;
        temp *= 1000000;
    }
    else 
    {
        temp = 1 / Freq;
        temp *= 1000000;
        temp /= div;
    }
    return (int)temp;
}

float WaveGen::VCalc(float Volt)
{
    float temp = Volt / 3.30;
    temp /= 2;
    return temp;
}

float WaveGen::RadCalc(float Ang)
{
    float temp = 0;
    temp = Ang * 0.0174532925;
    return temp;   
}

void WaveGen::SineWave(float Frequency,float Amplitude)
{
    float temp = 0;
    int T1 = TCalc(6,Frequency);//porzione 30°
    int T2 = TCalc(12,Frequency);//porzione 120°
    float V = VCalc(Amplitude) * 2;
    for(int a = 0; a <= 30; a += 5)
    {
        temp = 0.5 + V * sin(RadCalc((float)a));
        _WaveForm = temp;
        wait_us(T1);       
    }
    for(int b = 30; b <= 150; b += 10)
    {
        temp = 0.5 + V * sin(RadCalc((float)b));
        _WaveForm = temp;
        wait_us(T2);    
    } 
    for(int c = 150; c <= 210; c += 5)
    {
        temp = 0.5 + V * sin(RadCalc((float)c));
        _WaveForm = temp;
        wait_us(T1);    
    } 
    for(int d = 210; d <= 330; d += 10)
    {
        temp = 0.5 + V * sin(RadCalc((float)d));
        _WaveForm = temp;
        wait_us(T2);    
    } 
    for(int e = 330; e <= 360; e += 5)
    {
        temp = 0.5 + V * sin(RadCalc((float)e));
        _WaveForm = temp;
        wait_us(T1);    
    } 
}

void WaveGen::SquareWave(float Frequency,float Amplitude,float DutyCycle)
{
    float V = VCalc(Amplitude);
    float temp = 0;
    int Ton,Toff = 0;
    int Temp = TCalc(0,Frequency);
    if(DutyCycle != 50)
    {
        temp = DutyCycle / 100;
        temp *= (float)Temp;
        Ton = (int)temp;
        Toff = Temp - Ton;
    }
    else 
    {
        Ton = TCalc(0,Frequency);
        Toff = Ton;    
    } 
    _WaveForm = V;
    wait_us(Ton);
    _WaveForm = 0;
    wait_us(Toff);
}

void WaveGen::TriangularWave(float Frequency,float Amplitude)
{
    float temp = 0;
    int T = TCalc(50,Frequency);
    float V = VCalc(Amplitude);
    int min,max,pass;
    //Calcola gli intervalli di tensione
    temp = V * 1000;
    min = 500 - (int)temp;
    max = 500 + (int)temp;
    pass = (max - min) / 50;
    for(int a = min; a <= max; a += pass)
    {
        temp = (float)a;
        temp /= 1000;
        _WaveForm = temp;
        wait_us(T);   
    }
    for(int b = max; b >= min; b -= pass)
    {
        temp = (float)b;
        temp /= 1000;
        _WaveForm = temp;
        wait_us(T);   
    }
}

void WaveGen::SawToothWave(float Frequency,float Amplitude)
{
    float temp = 0;
    int T = TCalc(50,Frequency);
    float V = VCalc(Amplitude);
    int min,max,pass;
    temp = V * 100;
    min = 50 - (int)temp;
    max = 50 + (int)temp;
    pass = (max - min) / 50;
    for(int a = min; a <= max; a += pass)
    {
        temp = (float)a;
        temp /= 100;
        _WaveForm = temp;
        wait_us(T);
    }  
}
