/*THIS CLASS INTERFACE THE MDSMC by pololu (Micro Dual Serial Motor Controller)
WITH OUR MBED MODULE. THE MDSMC MUST BE USED WITH UART MODULE*/

#ifndef MBED_MDSMC_H
#define MBED_MDSMC_H

#include "mbed.h"

#define Start 0x80
#define ChangeConfig 0x02
#define Setting1 0x7F
#define Setting2 0x13
#define Device 0x00
#define Forward1 0x7F
#define Reverse1 0x7E
#define Forward2 0x27
#define Reverse2 0x26
#define Right 0x21
#define Left 0x05

class MDSMC
{
   public:
            /* - Declare Mbed connections
            ** - Select serial pin with "PinName data" parameter;
            ** - select reset pin with "PinName CLR" parameter;
            ** - select motor mode with "nM" parameter if you set nM = 1 the MDSMC drive one motor,
            **   if you set nM = 2 the MDSMC drive two motors;
            ** - select the baud rate with "bps" parameter you can select a bps value between 2000
            **   and 19200.*/
            MDSMC(PinName TX, PinName RX, PinName CLR, int bps, int nM);
            
            /* - Give direction and speed*/
            void use(char direction, char speed); 
   
   protected:
            Serial _serialMDSMC;
            DigitalOut _CLR;
            void reset();
};
typedef unsigned char BYTE;

#endif

/*example used to test the class

#include "mbed.h"
#include "MDSMC.h"

MDSMC(USBTX,USBRX,p5);

int main()
{
    MDSMC.init(1,9600);
    wait(1);
    MDSMC.use(Forward1, 80);
    wait(1);
    MDSMC.use(Reverse1, 80);
    wait(2);
    MDSMC.init(2,9600);
    wait(1);
    MDSMC.use(Forward2, 80);
    wait(1);
    MDSMC.use(Reverse2, 80);
    wait(1);
    MDSMC.use(Right, 50);
    wait(1);
    MDSMC.use(Left, 50);
}
*/