//.cpp file of MDSMC library

#include "mbed.h"
#include "MDSMC.h"

MDSMC::MDSMC(PinName TX, PinName RX, PinName CLR, int bps, int nM): _serialMDSMC(TX, RX), _CLR(CLR)
{    
    reset();
    _serialMDSMC.baud(bps);
    switch (nM)
    {
        case 1:
            _serialMDSMC.putc(Start);
            _serialMDSMC.putc(ChangeConfig);
            _serialMDSMC.putc(Setting1);
            reset();
            break;
        case 2:
            _serialMDSMC.putc(Start);
            _serialMDSMC.putc(ChangeConfig);
            _serialMDSMC.putc(Setting2);
            reset();
            break; 
    }
}  
 
//user functions
void MDSMC::use(char direction, char speed)
{
    _serialMDSMC.putc(Start);
    _serialMDSMC.putc(Device);
    _serialMDSMC.putc(direction);
    _serialMDSMC.putc(speed);
}                            

void MDSMC::reset()
{
    _CLR = 0;
    wait_us(2);
    _CLR = 1; 
} 

                                                                                  