#ifndef KEYPAD3x4POLLING_H
#define KEYPAD3x4POLLING_H

#include "BusOut.h"
#include "BusIn.h"

#define NO_PRESS 10

namespace mbed
{                  
    class Keypad
    {    
        public:
            Keypad(PinName col1,PinName col2,PinName col3,PinName row1,PinName row2,PinName row3,PinName row4);
            char read();
        protected:
            BusIn _cols;    
            BusOut _rows;
    };
}
#endif

/*SIMPLE EXAMPLE

#include "mbed.h"
#include "Keypad3x4polling.h"

Serial pc(USBTX,USBRX);

Keypad Keyboard(p17,p16,p15,p10,p9,p8,p7);

int main() 
{       
    char button;  
    pc.printf("Premi un tasto:");
    while(1)
    {
        button = Keyboard.read();
        if(button != NO_PRESS)
            pc.putc(button);  
        wait(0.2);             
    }    
}

*/