#include "mbed.h"
#include "Keypad3x4polling.h"

using namespace mbed;

Keypad::Keypad(PinName col1,PinName col2,PinName col3,PinName row1,PinName row2,PinName row3,PinName row4):_cols(col1,col2,col3),_rows(row1,row2,row3,row4)   
{ 
    _cols.mode(PullUp);
    _rows.write(0);     
}
char Keypad::read()
{
    char key = 10;
    _rows.write(14);//1110b
    switch(_cols)
    {
        case 3: key = '3'; break;//011b
        case 5: key = '2'; break;//101b
        case 6: key = '1'; break;//110b
    }
    _rows.write(13);//1101b
    switch(_cols)
    {
        case 3: key = '6'; break;
        case 5: key = '5'; break;
        case 6: key = '4'; break;
    }
    _rows.write(11);//1011b
    switch(_cols)
    {
        case 3: key = '9'; break;
        case 5: key = '8'; break;
        case 6: key = '7'; break;
    }
    _rows.write(7);//0111b
    switch(_cols)
    {
        case 3: key = '#'; break;
        case 5: key = '0'; break;
        case 6: key = '*'; break;
    }
    return key;
}