/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

// import external library
#include "ReceiverIR.h"
#include "TransmitterIR.h"

#define STATION_ID 13

Ticker tim_int;
TransmitterIR ir_tx(D9);
Serial pc(USBTX, USBRX, 115200);

//int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 100) {
//    int cnt = 0;
//    while (ir_rx.getState() != ReceiverIR::Received) {
//        cnt++;
//        if (timeout < cnt) {
//            return -1;
//        }
//    }
//    return ir_rx.getData(format, buf, bufsiz * 8);
//}

int transmit(RemoteIR::Format format, uint8_t *buf, int bufsiz, int timeout = 100) {
    int cnt = 0;
    while (ir_tx.getState() != TransmitterIR::Idle) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_tx.setData(format, buf, bufsiz * 8);
}

uint8_t check_sum(uint8_t *package_arr) {
  uint8_t answer = 0;
  answer =
      (package_arr[0] >> 4) + (package_arr[0] & 0x0F) + (package_arr[1] >> 4);
  return (answer & 0x0F);
}

// variable
RemoteIR::Format format;
bool ir_ena = 0;

void ir_tick() {ir_ena = 1;}

int main()
{
    tim_int.attach(&ir_tick, 0.2);
    
    uint8_t package[2] = {};
    uint8_t station_id = 0;
    uint8_t checksum_bits = 0;
    pc.printf("start %d\n", STATION_ID);
    while (true) {
        if (ir_ena){
            package[0] = 0xFF;
            package[1] = (station_id << 4); 
            checksum_bits = check_sum(package);
            package[1] += checksum_bits;
            format = RemoteIR::NEC;
            transmit(format, package, sizeof(package), 100);
            station_id++;
            if (station_id == 16) {station_id = 0;}
            pc.printf("s'\n");
            ir_ena = 0;
        }
        ThisThread::sleep_for(1);
    }
}
