#include "mbed.h"
#include "ReceiverIR.h"
#include "rtos.h"
#include <stdint.h>
#include "platform/mbed_thread.h"
#include "TextLCD.h"
RawSerial pc(USBTX, USBRX);
//Serial esp(p28, p27); // tx, rx

RawSerial esp(p13, p14); // tx, rx
// Standard Mbed LED definitions
DigitalOut  led1(LED1);    
DigitalOut  led2(LED2);    
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);     

Timer t1;
Timer t2;

struct tm t;


int bufflen, DataRX, count_wifi, getcount, replycount, servreq, timeout;
int bufl, ipdLen, linkID, weberror, webcounter,click_flag;
float temperature, AdcIn, Ht;
float R1=100000, R2=10000; // resistor values to give a 10:1 reduction of measured AnalogIn voltage
char Vcc[10];
char webcount[8];
char type[16];
char type1[16];
char channel[2];
char cmdbuff[32];
char replybuff[1024];

char webdata[1024]; // This may need to be bigger depending on WEB browser used
char webbuff[4096*4];     // Currently using 1986 characters, Increase this if more web page data added


void SendCMD(),getreply(),ReadWebData(),startserver(),sendpage(),sendpage2(),SendWEB(),sendcheck(),touchuan();
void wifi(void const *argument);

Thread wifi_thread(wifi, NULL, osPriorityNormal); // decodeIRをスレッド化 ：+3
int count_test=1;        //test
char battery_ch[8];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.

// Serial Interrupt read ESP data
void callback()
{
    //pc.printf("\n\r------------ callback is being called --------------\n\r");
    led3=1;
    while (esp.readable()) {
        webbuff[count_wifi] = esp.getc();
        count_wifi++;
    }
    if(strlen(webbuff)>bufflen) {
        pc.printf("\f\n\r------------ webbuff over bufflen --------------\n\r");
        DataRX=1;
        led3=0;
    }
}

void wifi(void const *argument){ 
   pc.baud(115200);

    pc.printf("\f\n\r------------ ESP8266 Hardware Reset psq --------------\n\r");
    wait(0.5);
    led1=1,led2=0,led3=0;
    timeout=6000;
    getcount=500;
    getreply();
    esp.baud(115200);   // ESP8266 baudrate. Maximum on KLxx' is 115200, 230400 works on K20 and K22F
    startserver();
    
    while(1) {
        if(DataRX==1) {
            pc.printf("\f\n\r------------ main while > if --------------\n\r");
            click_flag = 1;
            ReadWebData();
            pc.printf("\f\n\r------------ click_flag=%d --------------\n\r",click_flag); 
            //if ((servreq == 1 && weberror == 0) && click_flag == 1) {
            if (servreq == 1 && weberror == 0) {
                pc.printf("\f\n\r------------ befor send page --------------\n\r");        
                sendpage();
            }
            pc.printf("\f\n\r------------ send_check begin --------------\n\r"); 
            
            //sendcheck();
            pc.printf("\f\n\r------------ ssend_check end--------------\n\r"); 
            
            esp.attach(&callback);
            pc.printf(" IPD Data:\r\n\n Link ID = %d,\r\n IPD Header Length = %d \r\n IPD Type = %s\r\n", linkID, ipdLen, type);
            pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata);
            pc.printf("  Web Characters sent : %d\n\n", bufl);
            pc.printf("  -------------------------------------\n\n");
            servreq=0;
        }
    }
}
int main()
{
    while(1){
        Thread::wait(100);
    }
}
// Static WEB page
void sendpage()
{
// WEB page data

strcpy(webbuff, "<!DOCTYPE html>");
strcat(webbuff, "<html><head><title>RobotCar</title><meta name='viewport' content='width=device-width'/>");    
strcat(webbuff, "</head><body><center><p><strong>Robot Car Remot Controller");
strcat(webbuff, "</strong></p><td style='vertical-align:top;'><strong>Battery level ");
strcat(webbuff, "<input type=\"text\" id=\"leftms\" size=4 value=250>%</strong>");
strcat(webbuff, "</td></p><tr ><strong>Now speed : </strong></tr><nobr id=\"speprint\">ready");
strcat(webbuff, "</nobr><br><tr ><strong>Now action : </strong></tr>");
strcat(webbuff, "<nobr id=\"funprint\">ready</nobr><table><tr><td></td><td>");

strcat(webbuff, "<button id='gobtn' type='button' style='width:100px;height:60px'  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
strcat(webbuff, "</button></td><td></td></tr><tr><td>");
strcat(webbuff, "<button id='leftbtn' type='button' style='width:100px;height:60px' value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
strcat(webbuff, "</button></td><td>");

strcat(webbuff, "<button id='stopbtn' type='button' style='width:100px;height:60px' value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
strcat(webbuff, "</button></td><td>");
strcat(webbuff, "<button id='rightbtn' type='button' style='width:100px;height:60px' value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
strcat(webbuff, "</button></td></tr><td></td><td>");
strcat(webbuff, "<button id='backbtn' type='button' style='width:100px;height:60px' value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");



//begin
strcat(webbuff, "<strong>Addition functions:</strong><table>");
strcat(webbuff, "<td>");//ok
strcat(webbuff, "<button id='avoidbtn' type='button' style='width:100px;height:60px' value=\"AVOIDANCE\"  onClick='send_mes_fun(this.id,this.value)' >");
strcat(webbuff, "AVOIDANCE</button></td><td>");
strcat(webbuff, "<button id='tracebtn' type='button' style='width:100px;height:60px' value=\"LINETRACE\"  onClick='send_mes_fun(this.id,this.value)' >LINE TRACE");
strcat(webbuff, "</button></td></table><table><td>");
strcat(webbuff, "</td><strong>Speed level:</strong>");
strcat(webbuff, "</table><table><td>");
strcat(webbuff, "<button id='sp1btn' type='button' style='width:100px;height:60px' value=\"SLOW\"  onClick='send_mes_spe(this.id,this.value)' >SLOW");
strcat(webbuff, "</button></td><td>");
strcat(webbuff, "<button id='sp2btn' type='button' style='width:100px;height:60px' value=\"FAST\"  onClick='send_mes_spe(this.id,this.value)' >FAST");
strcat(webbuff, "</button>");
strcat(webbuff, "</td>");    
strcat(webbuff, "<td>");
strcat(webbuff, "<button id='sp3btn' type='button' style='width:100px;height:60px' value=\"VERYFAST\"  onClick='send_mes_spe(this.id,this.value)' >FLY");
strcat(webbuff, "</button>");
strcat(webbuff, "</td></table>");    
strcat(webbuff, "<table>");        
strcat(webbuff, "<td>");
strcat(webbuff, "</td>");    
strcat(webbuff, "</table>");    //end



strcat(webbuff, "</center>");
strcat(webbuff, "</body>");
strcat(webbuff, "</html>");
strcat(webbuff, "<script language=\"javascript\" type=\"text/javascript\">");
strcat(webbuff, "function send_mes(btnmes,btnval){");
strcat(webbuff, "var url = \"http://\" + window.location.hostname + \"/cargo?a=\" + btnval;");
strcat(webbuff, "htmlacs(url);");
strcat(webbuff, "console.log(url);");
strcat(webbuff, "}");

strcat(webbuff, "function htmlacs(url) {");
strcat(webbuff, "var xhr = new XMLHttpRequest();");
strcat(webbuff, "xhr.open(\"GET\", url ,true);");
strcat(webbuff, "xhr.send();");
strcat(webbuff, "}");


//0824 battery update auto
strcat(webbuff, "function battery_update() {");
strcat(webbuff, "var url1 =  \"http://\" + window.location.hostname+ \"/cargo?a=responseBattery\";");
strcat(webbuff, "var xhr1 = new XMLHttpRequest();");
strcat(webbuff, "xhr1.open(\"GET\", url1);");
//0820
strcat(webbuff, "xhr1.onreadystatechange = function(){");
            //strcat(webbuff, "console.log(\"onready function is being reload!\");");
            strcat(webbuff, "if(this.readyState == 4 && this.status == 200){");
            //strcat(webbuff, "console.log(\"state is being reload!\");");
                strcat(webbuff, "var res1 = xhr1.responseText;");
                strcat(webbuff, "document.getElementById('leftms').value=res1;}};");
                //strcat(webbuff, "console.log(res);}};");
//0820

strcat(webbuff, "xhr1.send();");
strcat(webbuff, "}");
strcat(webbuff, "setInterval(battery_update,10000);");

//0824 battery update auto
/*
strcat(webbuff, "function send_mes_spe(btnmes,btnval){");
strcat(webbuff, "var url = \"http://\" + window.location.hostname + \"/cargo?a=\" + btnval;");
strcat(webbuff, "htmlacs(url);");
strcat(webbuff, "if(document.getElementById(\"speprint\")){");
strcat(webbuff, "document.getElementById(\"speprint\").innerHTML=btnval;");
strcat(webbuff, "}");
strcat(webbuff, "}");
strcat(webbuff, "function send_mes_fun(btnmes,btnval){");
strcat(webbuff, "var url = \"http://\" + window.location.hostname + \"/cargo?a=\" + btnval;");
strcat(webbuff, "htmlacs(url);");
strcat(webbuff, "if(document.getElementById(\"funprint\")){");
strcat(webbuff, "document.getElementById(\"funprint\").innerHTML=btnval;");
strcat(webbuff, "}");
strcat(webbuff, "}");
*/
strcat(webbuff, "</script>");
// end of WEB page data
    bufl = strlen(webbuff); // get total page buffer length
    //sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
    
    sprintf(cmdbuff,"AT+CIPSENDBUF=%d,%d\r\n", linkID, (bufl>2048?2048:bufl)); // send IPD link channel and buffer character length.
    timeout=500;
    getcount=40;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("\n++++++++++ AT+CIPSENDBUF=%d,%d+++++++++\r\n", linkID, (bufl>2048?2048:bufl));
    
    pc.printf("\n++++++++++ bufl is %d ++++++++++\r\n",bufl);
    
    //pastthrough mode
    SendWEB();  // send web page
    pc.printf("\n++++++++++ webbuff clear  ++++++++++\r\n");
  
    memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();
}


void sendpage2()
{
// WEB page data

//strcpy(webbuff, "<script language=\"javascript\" type=\"text/javascript\">");
//strcat(webbuff, "document.getElementById('leftms').value=\"100\";");
count_test++;
sprintf(battery_ch,"%d",count_test);
strcpy(webbuff, battery_ch);

//strcpy(webbuff, "document.getElementById('leftms').value=\"100\";");

//strcat(webbuff, "</script>");
// end of WEB page data
    bufl = strlen(webbuff); // get total page buffer length
    //sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
    
    sprintf(cmdbuff,"AT+CIPSENDBUF=%d,%d\r\n", linkID, (bufl>2048?2048:bufl)); // send IPD link channel and buffer character length.
    timeout=500;
    getcount=40;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("\n++++++++++ AT+CIPSENDBUF=%d,%d+++++++++\r\n", linkID, (bufl>2048?2048:bufl));
    
    pc.printf("\n++++++++++ bufl is %d ++++++++++\r\n",bufl);
    
    //pastthrough mode
    SendWEB();  // send web page
    pc.printf("\n++++++++++ webbuff clear  ++++++++++\r\n");
  
    memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();
}


// Reads and processes GET and POST web data
void ReadWebData()
{
    pc.printf("+++++++++++++++++Read Web Data+++++++++++++++++++++\r\n");
    wait_ms(200);
    esp.attach(NULL);
    count_wifi=0;
    DataRX=0;
    weberror=0;
    memset(webdata, '\0', sizeof(webdata));
    int x = strcspn (webbuff,"+");
    if(x) {
        strcpy(webdata, webbuff + x);
        weberror=0;
        int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);
        //int i=0;
        pc.printf("+++++++++++++++++succed rec begin+++++++++++++++++++++\r\n");
        pc.printf("%s",webdata);
        pc.printf("+++++++++++++++++succed rec end+++++++++++++++++++++\r\n");
       if( strstr(webdata, "responseBattery") != NULL ) {
             click_flag = 0;
             led4=!led4;
             pc.printf("\r\n++++++++++++++mode = LEFT++++++++++++++\r\n");
             sendpage2();
/*
            strcpy(webbuff, "<script language=\"javascript\" type=\"text/javascript\">");
            strcat(webbuff, "document.getElementById('leftms').value=\"96\";");
             strcat(webbuff, "let request = new XMLHttpRequest();");
 strcat(webbuff, "request.open('GET', url);request.responseType = 'text';");
 strcat(webbuff, "request.onload = function() {  poemDisplay.textContent = request.response;};");

 strcat(webbuff, "request.send();");
            strcat(webbuff, "</script>"); 
            bufl = strlen(webbuff); // get total page buffer length
            sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
            timeout=500;
            getcount=40;
            SendCMD();
            getreply();
            SendWEB(); 
            memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();
            pc.printf("\r\n++++++++++++++mode = LEFT++++++++++++++\r\n");
*/
     
          /*              mode = LEFT;        // 左折モード
                        run = LEFT;         // 左折
                        display(); */
                        
        }
        if( strstr(webdata, "LEFT") != NULL ) {
            led4=!led4;
            pc.printf("mode = RIGHT\r\n");
                        
        }
       /*  
        if( strstr(webdata, "RIGHT") != NULL ) {
            led4=!led4;
            pc.printf("mode = RIGHT\r\n");
                        mode = RIGHT;       // 右折モード
                        run = RIGHT;        // 右折
                        display();          // ディスプレイ表示
        }
        
        if( strstr(webdata, "GO") != NULL ) {
            led4=!led4;
            pc.printf("mode = ADVANCE\r\n");
            mode = ADVANCE;     // 前進モード
            run = ADVANCE;      // 前進
            display();          // ディスプレイ表示
        }
        
        if( strstr(webdata, "BACK") != NULL ) {
            led4=!led4;
            pc.printf("mode = BACK\r\n");
            mode = BACK;        // 後退モード
            run = BACK;         // 後退
            display();          // ディスプレイ表示
        }
        
        if( strstr(webdata, "STOP") != NULL ) {
            led4=!led4;
             pc.printf("mode = STOP\r\n");
                        mode = STOP;        // 停止モード
                        run = STOP;         // 停止
                        display();          // ディスプレイ表示
        }
        
        if( strstr(webdata, "AVOIDANCE") != NULL ) {
            led4=!led4;
             pc.printf("mode = AVOIDANCE\r\n");
            mode=AVOIDANCE;     // 障害物回避モード
            run = ADVANCE;      // 前進
            display();   
        }
        
        if( strstr(webdata, "LINETRACE") != NULL ) {
            led4=!led4;
            pc.printf("mode = LINE_TRACE\r\n");
            mode=LINE_TRACE;    // ライントレースモード
            display();   
        }
        
        if( strstr(webdata, "SLOW") != NULL ) {
            led4=!led4;
            pc.printf("\r\n+++++++++++++++++bbutton right clicked+++++++++++++++++++++\r\n");
        }
        
        if( strstr(webdata, "FAST") != NULL ) {
            led4=!led4;
            pc.printf("\r\n+++++++++++++++++bbutton right clicked+++++++++++++++++++++\r\n");
        }
        
        if( strstr(webdata, "VERYFAST") != NULL ) {
            led4=!led4;
            pc.printf("\r\n+++++++++++++++++bbutton right clicked+++++++++++++++++++++\r\n");
        }*/
        sprintf(channel, "%d",linkID);
        if (strstr(webdata, "GET") != NULL) {
            servreq=1;
            pc.printf("\r\n+++++++++++++++++GET+++++++++++++++++++++\r\n");

        }
        if (strstr(webdata, "POST") != NULL) {
            servreq=1;
            pc.printf("\r\n+++++++++++++++++POST+++++++++++++++++++++\r\n");
        }
        webcounter++;
        sprintf(webcount, "%d",webcounter);
    } else {
        pc.printf("\n++++++++++ webbuff clear  ++++++++++\r\n");
        memset(webbuff, '\0', sizeof(webbuff));
        esp.attach(&callback);
        weberror=1;
    }
}
// Large WEB buffer data send
void SendWEB()
{
    int i=0;
    if(esp.writeable()) {
        while(webbuff[i]!='\0') {
            esp.putc(webbuff[i]);
                 
          //****
          //output at command when 2000 
            if(((i%2047)==0) && (i>0)){    
                    //wait_ms(10);
                    sprintf(cmdbuff,"AT+CIPSENDBUF=%d,%d\r\n", linkID, (bufl-2048)>2048?2048:(bufl-2048)); // send IPD link channel and buffer character length.
                    pc.printf("\r\n++++++++++ AT+CIPSENDBUF=%d,%d ++++++++++\r\n", linkID, (bufl-2048)>2048?2048:(bufl-2048));
                    timeout=600;
                    getcount=50;
                    SendCMD();
                    getreply();
                    pc.printf(replybuff);
                    pc.printf("\r\n+++++++++++++++++++\r\n");
               }    
    //****  
            i++;     
            pc.printf("%c",webbuff[i]);
        }
    }
     pc.printf("\n++++++++++ send web i= %dinfo ++++++++++\r\n",i);
}


    
void sendcheck()
{
    weberror=1;
    timeout=500;
    getcount=24;
    t2.reset();
    t2.start();
    
    /*
    while(weberror==1 && t2.read() <5) {
        getreply();
        if (strstr(replybuff, "SEND OK") != NULL) {
            weberror=0;   // wait for valid SEND OK
        }
    }
    */
    if(weberror==1) { // restart connection
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n");
        timeout=500;
        getcount=10;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
        timeout=500;
        getcount=10;
        SendCMD();
        getreply();
        pc.printf(replybuff);
    } else {
        sprintf(cmdbuff, "AT+CIPCLOSE=%s\r\n",channel); // close current connection
        SendCMD();
        getreply();
        pc.printf(replybuff);
    }
    t2.reset();
}

// Starts and restarts webserver if errors detected.
void startserver()
{
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"AT+RST\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("%d",count_wifi);
    if (strstr(replybuff, "OK") != NULL) {
        pc.printf("\n++++++++++ Starting Server ++++++++++\r\n");
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n");  // set multiple connections.
        timeout=500;
        getcount=20;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
        timeout=500;
        getcount=20;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        wait(1);
        sprintf(cmdbuff,"AT+CIPSTO=%d\r\n",SERVtimeout);
        timeout=500;
        getcount=50;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        //wait(5);
        wait(1);
        pc.printf("\n Getting Server IP \r\n");
        strcpy(cmdbuff, "AT+CIFSR\r\n");
        timeout=2500;
        getcount=200;
        while(weberror==0) {
            SendCMD();
            getreply();
            if (strstr(replybuff, "0.0.0.0") == NULL) {
                weberror=1;   // wait for valid IP
            }
        }
        pc.printf("\n Enter WEB address (IP) found below in your browser \r\n\n");
        pc.printf("\n The MAC address is also shown below,if it is needed \r\n\n");
        replybuff[strlen(replybuff)-1] = '\0';
        //char* IP = replybuff + 5;
        sprintf(webdata,"%s", replybuff);
        pc.printf(webdata);
        led2=1;
        bufflen=200;
        //bufflen=100;
        count_wifi=0;
        pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
        esp.attach(&callback);
    } else {
        pc.printf("\n++++++++++ ESP8266 error, check power/connections ++++++++++\r\n");
        led1=1;
        led2=1;
        led3=1;
        led4=1;
        while(1) {
            led1=!led1;
            led2=!led2;
            led3=!led3;
            led4=!led4;
            wait(1);
        }
    }
    t2.reset();
    t2.start();
}
// ESP Command data send
void SendCMD()
{
    esp.printf("%s", cmdbuff);
}
// Get Command and ESP status replies
void getreply()
{
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset();
    t1.start();
    replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();
            replycount++;
        }
    }
    t1.stop();
}