/*****************************************************/
/*  Distotion_Unit.cpp                               */
/*                                                   */
/*****************************************************/

#define     DIST_MAIN
#include    "Distotion_Unit.h"

#define  LIMIT_P        (32767)
#define  LIMIT_N        (-32768)

int distotion(int iEffectIn) {

    int iSignal;
    int iClip;
    
    // Bypass ?
    if(g_iDistBypass == 0)return iEffectIn;

    // Input Gain
    iSignal = iEffectIn * g_iDistInputGain / 10;

    iClip = 32767 * g_iDistClipLevel / 100;

    // Clip
    switch(g_iDistMode){
        case 1: if (iSignal < 0)iSignal *= (-1);
                if (iSignal >= iClip)iSignal = iClip;
                break;
        case 2: if (iSignal >= iClip)iSignal = iClip;
                if (iSignal <= -iClip)iSignal = -iClip;
                break;
        case 3: if (iSignal >= iClip)iSignal = iClip;
                if (iSignal <= (-iClip / 2))iSignal = (-iClip / 2);
                break;
        default:break;
    }
        
    // Output Gain
    iSignal = iSignal * g_iDistOutputGain / 10;
    if (iSignal >= LIMIT_P)iSignal = LIMIT_P;
    if (iSignal <= LIMIT_N)iSignal = LIMIT_N;

    return iSignal;

}

#undef      DIST_MAIN