/*****************************************************/
/*  Delay_Unit.cpp                                   */
/*                                                   */
/*****************************************************/

#define     DELAY_MAIN
#include    "Delay_Unit.h"

#define  LIMIT_P        (32767)
#define  LIMIT_N        (-32768)

int delay(int iEffectIn) {

    int iSignal;

    // Bypass ?
    if(g_iDelayBypass == 0)return iEffectIn;

    // Delay
    iSignal = (int)g_sDelayBuff[g_usDelayPoint] * g_iDelayFeedBackLevel / 100 + iEffectIn;
        
    // Output Gain
    if (iSignal >= LIMIT_P)iSignal = LIMIT_P;
    if (iSignal <= LIMIT_N)iSignal = LIMIT_N;

    g_sDelayBuff[g_usDelayPoint] = iSignal;

    g_usDelayPoint = (g_usDelayPoint + 1) % (MAX_DELAY_POINT * g_iDelayTime / MAX_DELAY_TIME);

    return iSignal;

}

#undef      DELAY_MAIN