/*****************************************************/
/* MBED MULTI EFFECTOR                               */
/*                                                   */
/*                                                   */
/*****************************************************/

#include "mbed.h"
#include "TextLCD.h"
#include "R_Sw_Check.h"
#include "Distotion_Unit.h"

Ticker      sampling;
AnalogIn    Ain(p17);
AnalogOut   Aout(p18);
TextLCD     lcd(p24, p25, p26, p27, p28, p29, p30);     // rs, rw, e, d0, d1, d2, d3)
DigitalIn   Rsw0A(p5);
DigitalIn   Rsw0B(p6);
DigitalIn   Rsw1A(p7);
DigitalIn   Rsw1B(p8);
DigitalIn   Rsw2A(p9);
DigitalIn   Rsw2B(p10);
DigitalIn   Rsw3A(p11);
DigitalIn   Rsw3B(p12);

/*******************************/
/* For Test Signal             */
/*******************************/
#define     TEST_SIGNAL_ENABLE      (0)                 // 1 : Internal SinWave for Debug
#define     TEST_SIGNAL_FREQ        (1000.0)            // Frequency [Hz]    
#define     TEST_SIGNAL_AMP         (30000.0)           // Amplitude
#define     PAI                     (3.14159)

/*******************************/
/* For ADC & DAC Setting       */
/*******************************/
#define     SAMPLING_TIME           (25.0)              // ADC Sampling Rate [us]

volatile unsigned int   *g_usiAd0cr, *g_usiAd0dr2;      // ADC Reg
unsigned int            *g_usiDacr;                     // DAC Reg
unsigned int            g_usiFinalOut;
int                     g_ssBuff[10];
float                   g_fTestWaveT;

/*******************************/
/* Effect Process              */
/*******************************/
void effectProcess() {
    // Line Out
    *g_usiDacr = g_usiFinalOut;
    // ADC Start
    *g_usiAd0cr = 0x01200204;

#if (TEST_SIGNAL_ENABLE == 1)           // Test Signal Sin Wave
    g_ssBuff[0] = TEST_SIGNAL_AMP * sin(g_fTestWaveT);
    g_fTestWaveT = g_fTestWaveT + 2.0 * PAI * SAMPLING_TIME * TEST_SIGNAL_FREQ  / 1e6;
    if (g_fTestWaveT >= (2.0 * PAI))g_fTestWaveT = 0;
#endif

    //
    // Effect Func();
    //
    
    g_ssBuff[1] = distotion(g_ssBuff[0]);
    
    //
    // Effect Func();
    //

#if (TEST_SIGNAL_ENABLE == 0)
    while (1) {
        if ((*g_usiAd0dr2 & 0x80000000) != 0)break; // ADC Done ?
    }
    g_ssBuff[0] = (int)(*g_usiAd0dr2 & 0x0000FFF0) - 32768;
#endif

    g_usiFinalOut = 0x00010000 | (g_ssBuff[1] + 32768);
}


/*******************************/
/* MAIN                        */
/*******************************/
int main() {

    int    iParamSwPol[4];
    
    // LCD INIT
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Dist Mode Type %d", g_distMode);
    lcd.locate(0,1);
    lcd.printf("Input Gain %4.1f", g_inputGain);
    lcd.locate(0,2);
    lcd.printf("Clip Level %6d", g_clipLevel);
    lcd.locate(0,3);
    lcd.printf("Output Gain %4.1f", g_outputGain);                    
    
    // ADC & DAC SETTING
    g_usiAd0cr     = (unsigned int*)0x40034000;
    g_usiAd0dr2    = (unsigned int*)0x40034018;
    g_usiDacr      = (unsigned int*)0x4008C000;
    
    // SAMPLING TIMER START
    sampling.attach_us(&effectProcess, SAMPLING_TIME);


    while (1) {

        //
        // Parameter Setting Func
        //

        switch(ucRotarySwPol(Rsw0A, Rsw0B, Rsw1A, Rsw1B, Rsw2A, Rsw2B, Rsw3A, Rsw3B, iParamSwPol)){
            case 0: g_distMode = g_distMode + iParamSwPol[0];
                    if(g_distMode <= 0)g_distMode = 3;
                    if(g_distMode > 3)g_distMode = 1;
                    lcd.locate(0,0);
                    lcd.printf("                 ");
                    lcd.locate(0,0);
                    lcd.printf("Dist Mode Type %d", g_distMode);
                    break;                    
            case 1: g_inputGain = g_inputGain + 0.5 * iParamSwPol[1];
                    lcd.locate(0,1);
                    lcd.printf("                 ");
                    lcd.locate(0,1);
                    lcd.printf("Input Gain %4.1f", g_inputGain);
                    break;
            case 2: g_clipLevel = g_clipLevel + 1000 * iParamSwPol[2];
                    lcd.locate(0,2);
                    lcd.printf("                 ");
                    lcd.locate(0,2);
                    lcd.printf("Clip Level %6d", g_clipLevel);
                    break;                    
            case 3: g_outputGain = g_outputGain + 0.5 * iParamSwPol[3];
                    lcd.locate(0,3);
                    lcd.printf("                 ");
                    lcd.locate(0,3);
                    lcd.printf("Output Gain %4.1f", g_outputGain);
                    break;
            default:break;
        }
        
        //
        // Parameter Setting Func
        //
        
    }
}

