/*****************************************************/
/*  Distotion_Unit.cpp                               */
/*                                                   */
/*****************************************************/

#define     DIST_MAIN
#include    "Distotion_Unit.h"

#define  LIMIT_P        (32767)
#define  LIMIT_N        (-32768)

int distotion(int iEffectIn) {

    int iSignal;

    // Input Gain
    iSignal = iEffectIn * g_inputGain;

    // Clip
    switch(g_distMode){
        case 1: if (iSignal < 0)iSignal *= (-1);
                if (iSignal >= g_clipLevel)iSignal = g_clipLevel;
                break;
        case 2: if (iSignal >= g_clipLevel)iSignal = g_clipLevel;
                if (iSignal <= -g_clipLevel)iSignal = -g_clipLevel;
                break;
        case 3: if (iSignal >= g_clipLevel)iSignal = g_clipLevel;
                if (iSignal <= (-g_clipLevel / 2))iSignal = (-g_clipLevel / 2);
                break;
        default:break;
    }
        
    // Output Gain
    iSignal *= g_outputGain;
    if (iSignal >= LIMIT_P)iSignal = LIMIT_P;
    if (iSignal <= LIMIT_N)iSignal = LIMIT_N;

    return iSignal;

}

#undef      DIST_MAIN