/*****************************************************/
/* MBED MULTI EFFECTOR                               */
/*                                                   */
/*                                                   */
/*****************************************************/

#include "mbed.h"
#include "Distotion_Unit.h"

Ticker      sampling;
AnalogIn    Ain(p17);
AnalogOut   Aout(p18);

/*******************************/
/* For Test Signal             */
/*******************************/
#define     TEST_SIGNAL_ENABLE      (0)                 // 1 : Internal SinWave for Debug
#define     TEST_SIGNAL_FREQ        (1000.0)            // Frequency [Hz]    
#define     TEST_SIGNAL_AMP         (30000.0)           // Amplitude
#define     PAI                     (3.14159)

/*******************************/
/* For ADC & DAC Setting       */
/*******************************/
#define     SAMPLING_TIME           (25.0)              // ADC Sampling Rate [us]

volatile unsigned int   *g_usiAd0cr, *g_usiAd0dr2;      // ADC Reg
unsigned int            *g_usiDacr;                     // DAC Reg
unsigned int            g_usiFinalOut;
int                     g_ssBuff[10];
float                   g_fTestWaveT;

/*******************************/
/* Effect Process              */
/*******************************/
void effectProcess() {
    // Line Out
    *g_usiDacr = g_usiFinalOut;
    // ADC Start
    *g_usiAd0cr = 0x01200204;

#if (TEST_SIGNAL_ENABLE == 1)           // Test Signal Sin Wave
    g_ssBuff[0] = TEST_SIGNAL_AMP * sin(g_fTestWaveT);
    g_fTestWaveT = g_fTestWaveT + 2.0 * PAI * SAMPLING_TIME * TEST_SIGNAL_FREQ  / 1e6;
    if (g_fTestWaveT >= (2.0 * PAI))g_fTestWaveT = 0;
#endif

    //
    // Effect Func();
    //
    g_ssBuff[1] = distotion(g_ssBuff[0]);
    //
    // Effect Func();
    //

#if (TEST_SIGNAL_ENABLE == 0)
    while (1) {
        if ((*g_usiAd0dr2 & 0x80000000) != 0)break; // ADC Done ?
    }
    g_ssBuff[0] = (int)(*g_usiAd0dr2 & 0x0000FFF0) - 32768;
#endif

    g_usiFinalOut = 0x00010000 | (g_ssBuff[1] + 32768);
}


/*******************************/
/* MAIN                        */
/*******************************/
int main() {

    g_usiAd0cr     = (unsigned int*)0x40034000;
    g_usiAd0dr2    = (unsigned int*)0x40034018;
    g_usiDacr      = (unsigned int*)0x4008C000;
    sampling.attach_us(&effectProcess, SAMPLING_TIME);

    while (1) {

        //
        // Parameter Setting Func()
        //

    }
}

