#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
Serial pc(USBTX, USBRX);
FILE *fp;
FILE *dp; 

char buffer[1024];

AnalogIn sensor(PTB2); 

InterruptIn event(PTB3);
AnalogOut led(PTC10);

int interrupt = 0;
Timer clk; 
Timer clkb;

/*Configuration_settings*/
typedef struct {
        float min_angle;
        float max_angle;
        float step_size;
    } data;
    data config;
    
void ReadConfigurationSettings()
{   
    //http://www.inmoov.fr/wp-content/uploads/2015/02/Introduction-to-Servo-Motors-Arduino.pdf
    //length of pulse corresponds to angle the servo must turn to
    //1 ms = 0deg, 1.5ms = 90
    //2 ms = 180deg
  
    
    pc.printf("Initializing \n");
     dp = fopen("/sd/config.txt", "r");
    if(dp == NULL) {
        pc.printf("Could not open file for write\r\n");
    }
    
     pc.printf("Found the file!");
     while(!feof (dp)){
       fscanf(dp, "%f ", &config.min_angle);// in degrees
       fscanf(dp, "%f ", &config.max_angle);// in degrees
       fscanf(dp, "%f  ", &config.step_size);//in degrees
             
       }
       pc.printf("%f, %f, %f", config.min_angle, config.max_angle, config.step_size);
       fclose(dp);
     
       
    
}


void trigger(){
    interrupt = abs((interrupt - 1) );
    led = !led; 
    //angle = angle+step_size;
   // return angle; 
    }
    
void BackgroundReading()
//this function opens the sd folder and saves the background reading for 10seconds
{
 float time; 
 float reading; 
 FILE *fp = fopen("/sd/mydir/data.csv", "a");   
 if (fp == NULL){
     pc.printf("Could not opne file for write \r \n");
     }
    //start the time and record background for 10seconds
    clkb.start();
    time = clkb.read(); 
    fprintf(fp, "Background reading\n");
     
     while(time < 10)
     {
         reading = sensor.read();
         //save in buffer 
    }
    //at the end of the 10 seconds write in file 
    
     
}
    
void OpenCsv()
{
    mkdir("/sd/mydir", 0777); //make directrory
    wait(0.2);
    
   FILE *fp = fopen("/sd/mydir/data.csv", "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\r\n");
    }
    fprintf(fp, "value, time, angle \n");
    fclose(fp);
}
void SaveCsv(FILE *fp, float value, float time, float angle)
{
    fp = fopen("/sd/mydir/data.csv", "a");
    fprintf(fp, "%d, %3f ,%f \n", angle, time, value);
    fclose(fp);
    }

int main() {
    
        event.rise(&trigger);
        float value = 0.0;
        float time_ms = 0.0, time_s =0.0, step_time = 0.0; 
        int angle =0 ;
        
        
        
        ReadConfigurationSettings();
        wait(2);
        OpenCsv();
        
        clk.start(); 
        time_s = (clk.read_ms())/1000;
        
        while (1){ //run for specific time.
        value = sensor.read();
         time_ms = clk.read_ms();
        if (time_ms < 500)
        {
            time_s = time_ms/1000;
            }
        else {
        time_s =  ((time_ms + 500)/1000 );  //convert milliseconds to seconds
        }
        __disable_irq();
        if(interrupt == 0){
        SaveCsv(fp, angle, time_s, value);
        pc.printf("%f, %3f\n", value, time_s);
        }
        
        __enable_irq();
        }
        
        fclose(fp);
     
    
}


