#ifndef TIMED_SWITCH_H
#define TIMED_SWITCH_H

enum {LedOff = 0, LedOn = 1};

const float WAIT_TIME = 0.2;    // to avoid bouncing
const float WAIT_ON = 0.5;
const float WAIT_OFF = 0.5;
const unsigned short time_correction = WAIT_TIME * 1000; // correction in msec.

Timer t;                               // for tracking time
unsigned int button_hold_duration;     // for tracking how long was the button holded (in msec)

DigitalIn button(p20);
DigitalOut myled(LED3);

void flash_led();
void debounce();

#endif
