#include "mbed.h"
#include "timed_switch.h"

void flash_led()
{
    myled = LedOn;
    wait(WAIT_ON);
    myled = LedOff;
    wait(WAIT_OFF);
};

void debounce()
{
    // debouncing
    while (button) {
        wait(WAIT_TIME);
    }
};

int main(void)
{
    t.start();

    while (true) {
        if (button) {
            // start counting time when the button is pressed
            t.reset();
            
            debounce();

            // remove the debouncing delay from the counted time
            button_hold_duration = t.read_ms() - time_correction;

            /* start couting time again and flash the LED
               after the button is released */
            t.reset();
            while (t.read_ms() < button_hold_duration) {
                flash_led();
            }
        }
    }
}