#include "mbed.h"
#include "temperature.h"

static const char CLS[] = "\x1B[2J";    // VT100 erase screen
static const char HOME[] = "\x1B[H";    // VT100 home

static const int SAMPLES = 100;         // use an average for better precision
enum { delay = 1 };

int main() 
{
    clear_screen();
    pc.printf("========[ Temperature ]========");
    
    while (true) 
    {
        pc.printf(HOME);
        float voltage = measure_voltage(SAMPLES);
        float temperature = voltage_to_temperature(voltage, SAMPLES);
        pc.printf("\n\rtemperature: %4.1f C", temperature);
        wait(delay);
    }
}

void clear_screen()
{
    pc.printf(CLS);      
    pc.printf(HOME);               
}

float measure_voltage(int samples)
{
    float voltage = 0;
    for (int i = 0; i < samples; ++i)
    {
        voltage += temperatureIn;
    }
    return voltage;
}

float voltage_to_temperature(int voltage, int samples)
{
    float temperature = (voltage / 0.01) / samples;
    return temperature;
}
