#include "mbed.h"
#include "Servo.h"
#include "usb-servo.h" 


static const char CLS[] = "\x1B[2J";        // VT100 erase screen
static const char HOME[] = "\x1B[H";        // VT100 home

static const float INITIAL_RANGE = 0.0005;
static const float INITIAL_POSITION = 0.5;

static const float CLOCK = 0.0;
static const float CCLOCK = 1.0;
static const float RANGE_MODIFIER = 0.0001;

struct Movement
{   
    private:    
        float calibration;
        
    public:
        float range;
        float position;
     
        Movement(float r, float p) : range(r), position(p)
        {
            calibration = 45.0;
        };
        
        float getCalibration() const
        {
            return calibration;
        }
};
 
int main() {
    clear_screen();
    show_menu();
    Movement movement(INITIAL_RANGE, INITIAL_POSITION);
    
    while (true) 
    {                  
        switch(pc.getc()) 
        {
            case '1': 
                movement.position = CLOCK;
                break;
            case '2': 
                movement.position = CCLOCK;
                break;
            case '3': 
                movement.range += RANGE_MODIFIER;
                break; 
            case '4': 
                movement.range -= RANGE_MODIFIER;
                break;
        }
        pc.printf("position = %.1f, range = +/-%0.4f\n\r", movement.position, movement.range);
        update(myservo, movement);
    }
}

void clear_screen()
{
    pc.printf(CLS);      
    pc.printf(HOME);               
}

void show_menu()
{
    pc.printf("\rServo controls:\n\r");
    pc.printf("1. Full speed clockwise\n\r");
    pc.printf("2. Full speed counter-clockwise\n\r");
    pc.printf("3. Increase speed\n\r");
    pc.printf("4. Decrease speed\n\r");
}

void update(const Servo& servo, const Movement& move)
{
    myservo.calibrate(move.range, move.getCalibration()); 
    myservo = move.position;    
}