#include "infrared.h"

static const char cls[] = "\x1B[2J";
static const char home[] = "\x1B[H";
static const float DEBOUNCING_DELAY = 0.1;
static const float TEXT_DELAY = 0.5;
enum led_state { OFF = 0, ON = 1 };

int main()
{
    pc.printf(home);
    pc.printf(cls);
    
    while (true) 
    {
        if (!infrared) 
        {
            set_led(my_led, ON, DEBOUNCING_DELAY);
            std::string alert("Intrusion dectected: " + current_date_time());
            show_alert(alert, TEXT_DELAY);
        }
        else 
        {
            set_led(my_led, OFF, DEBOUNCING_DELAY);
        }
    }
}

void set_led(DigitalOut led, led_state state, const float delay)
{
    led = state;
    wait(delay);
}

const std::string current_date_time() 
{
    time_t rawtime;
    time(&rawtime);
    return ctime(&rawtime);
}

void show_alert(const std::string& alert, const float delay) 
{
    pc.printf(home);
    pc.printf(alert.c_str());
    pc.printf("\r");
    wait(delay);
}


