#include "mbed.h"
#include "human_detector.h"

static const char CLS[] = "\x1B[2J";        // VT100 erase screen
static const char HOME[] = "\x1B[H";        // VT100 home
static const float DEBOUNCING_DELAY = 0.2;
enum state { OFF = 0, ON = 1 };

int main() 
{
    clear_screen();
    while (true) 
    {        
        init(potout, led);
        while (!potin) {} // wait until there's a pot (capacitor) charge
        alarm(led);
    }
}

void clear_screen()
{
    pc.printf(CLS);      
    pc.printf(HOME);               
}

void init(DigitalOut& pot, DigitalOut& led)
{
    pot = ON;
    led = OFF;
}

void alarm(DigitalOut& led)
{
    led = ON;
    pc.printf("Human detected\r\n");    
    wait(DEBOUNCING_DELAY);
}
