#include "mbed.h"
#include "HMC5883L.h"
#include "DHT.h"
#include "ADXL345.h"
#include "SerialGPS.h"

//SerialGPS gps(D1, D0);
DHT sensor(D6, DHT22);
Serial pc(A7, NC); // tx, rx 
Serial rfid(NC, D4); //tx, rx
//DigitalIn btn(PC_13);

InterruptIn button_RFID(PA_9);
InterruptIn button_SOS(PB_0);

DigitalOut led(LED2);
 
void ReadRFID_CALLBACK();
void SOS_CALLBACK() ;

 // Utility Boussole HMC5883L
#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif
#define PI2         (2*M_PI)
#define RAD_TO_DEG  (180.0/M_PI)
#define DEG_TO_RAD  (M_PI/180.0)
#define  DECLINATION_ANGLE -0.02123
#define SDA      A4
#define SCL      A5
 
int    SOSEtat; 
float  temp,Humidity;
int RFID=0;



int main()
{   

    // variable DHT11 ///////////////////////////
    int err;
    
    // configuration du BTN RFID
    button_RFID.mode(PullUp);
    button_RFID.fall(&ReadRFID_CALLBACK);  // attach the address of the flip function to the rising edge
    led = 0;
    // configuration du BTN SOS
    button_SOS.mode(PullUp);
    button_SOS.fall(&SOS_CALLBACK);  // attach the address of the flip function to the rising edge
    led = 0;

    while(1) 
    { 
    RFID=0;
    SOSEtat=0;
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation de la boussole ///////////////////////////
////////////////////////////////////////////////////////////////////////////////

        
        
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation du capteur de température/////////////////
////////////////////////////////////////////////////////////////////////////////
        err = sensor.readData();
        if (err==0){
            temp=sensor.ReadTemperature(CELCIUS);
            Humidity=sensor.ReadHumidity();
            SOSEtat=0;
           // pc.printf("AT$SS=%x%x%x%x0000\r\n",(int)temp,(int)Humidity,SOSEtat,RFID);  
       }
        //pc.printf("*********************\r\n");         
        

        //pc.printf("AT$SS=%x%x0000\r\n",SOSEtat,RFID);  

        
////////////////////////////////////////////////////////////////////////////////
//////////////////////////     Sigfox     ////////////:::::::::::::::///////////
////////////////////////////////////////////////////////////////////////////////
   // pc.printf("AT$SS=%x %x   \r\n",(int)sensor.ReadTemperature(CELCIUS),(int)sensor.ReadHumidity(),(int)RFID);
   // pc.printf("AT$SS= %x %x \r\n",(int)sensor.ReadTemperature(CELCIUS),(int)sensor.ReadHumidity());

    wait(3); 
    }  
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation RFID /////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
void ReadRFID_CALLBACK() {
    // configuration RFID 
    int i;
    int RFID_read[15];
    pc.printf("RFID_read1 : \r\n");     
    for(i=0;i<5;i++)
        RFID_read[i]=rfid.getc();
    for(i=0;i<5;i++)
        RFID=RFID+RFID_read[i];
    pc.printf("AT$SS=%x%x0000\r\n",SOSEtat,RFID);  
    wait(3);

}

////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation GPS_SOS //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
void SOS_CALLBACK() {
            //pc.printf("AT$SS=SOS \r\n");    
            SOSEtat=1;
            pc.printf("AT$SS=%x%x0000\r\n",SOSEtat,RFID);  


}